<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ContenidoController extends Controller
{
    // Estructura de contenido educativo
    private $contenido = [
        'matematicas' => [
            'titulo' => 'Matemáticas',
            'descripcion' => 'Aprende conceptos fundamentales de matemáticas',
            'temas' => [
                'algebra' => [
                    'titulo' => 'Álgebra',
                    'descripcion' => 'Ecuaciones, variables y expresiones algebraicas',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => '¿Qué es el Álgebra?',
                            'texto' => 'El álgebra es la rama de las matemáticas que estudia las estructuras, relaciones y cantidades. Utiliza letras y símbolos para representar números y cantidades en fórmulas y ecuaciones.'
                        ],
                        [
                            'tipo' => 'concepto',
                            'titulo' => 'Variables',
                            'texto' => 'Las variables son símbolos (generalmente letras) que representan valores desconocidos o que pueden cambiar. Por ejemplo: x, y, z.',
                            'ejemplo' => 'Si x = 5, entonces 2x = 10'
                        ],
                        [
                            'tipo' => 'concepto',
                            'titulo' => 'Ecuaciones Lineales',
                            'texto' => 'Una ecuación lineal es una igualdad que involucra variables de primer grado.',
                            'ejemplo' => '2x + 3 = 11<br>Solución: x = 4'
                        ],
                        [
                            'tipo' => 'ejercicio',
                            'titulo' => 'Ejercicios Prácticos',
                            'problemas' => [
                                'Resuelve: 3x + 5 = 20',
                                'Simplifica: 2(x + 3) + 4x',
                                'Encuentra x: 5x - 7 = 18'
                            ]
                        ]
                    ],
                    'recursos' => [
                        ['tipo' => 'video', 'titulo' => 'Introducción al Álgebra', 'url' => '#'],
                        ['tipo' => 'pdf', 'titulo' => 'Ejercicios de Álgebra', 'url' => '#']
                    ]
                ],
                'geometria' => [
                    'titulo' => 'Geometría',
                    'descripcion' => 'Figuras, áreas, perímetros y teoremas',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'Geometría Básica',
                            'texto' => 'La geometría estudia las propiedades y medidas de las figuras en el espacio o en el plano.'
                        ],
                        [
                            'tipo' => 'concepto',
                            'titulo' => 'Área de Figuras',
                            'texto' => 'El área es la medida de la superficie de una figura.',
                            'ejemplo' => 'Área del rectángulo = base × altura<br>Área del círculo = π × r²'
                        ]
                    ]
                ],
                'calculo' => [
                    'titulo' => 'Cálculo',
                    'descripcion' => 'Límites, derivadas e integrales',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'Introducción al Cálculo',
                            'texto' => 'El cálculo es la rama de las matemáticas que estudia el cambio continuo.'
                        ]
                    ]
                ]
            ]
        ],
        'lenguaje' => [
            'titulo' => 'Lenguaje y Comunicación',
            'descripcion' => 'Gramática, ortografía y literatura',
            'temas' => [
                'gramatica' => [
                    'titulo' => 'Gramática',
                    'descripcion' => 'Reglas y estructuras del idioma español',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'La Gramática Española',
                            'texto' => 'La gramática es el conjunto de reglas que rigen el uso correcto del idioma español.'
                        ],
                        [
                            'tipo' => 'concepto',
                            'titulo' => 'Sustantivos',
                            'texto' => 'Los sustantivos son palabras que nombran personas, animales, cosas o ideas.',
                            'ejemplo' => 'Ejemplos: casa, perro, María, libertad'
                        ],
                        [
                            'tipo' => 'concepto',
                            'titulo' => 'Verbos',
                            'texto' => 'Los verbos expresan acciones, estados o procesos.',
                            'ejemplo' => 'Ejemplos: correr, estar, pensar'
                        ]
                    ]
                ],
                'ortografia' => [
                    'titulo' => 'Ortografía',
                    'descripcion' => 'Reglas de escritura correcta',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'Ortografía Correcta',
                            'texto' => 'La ortografía establece las normas para escribir correctamente las palabras.'
                        ]
                    ]
                ],
                'literatura' => [
                    'titulo' => 'Literatura',
                    'descripcion' => 'Análisis literario y géneros',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'Introducción a la Literatura',
                            'texto' => 'La literatura es el arte de la expresión escrita o hablada.'
                        ]
                    ]
                ]
            ]
        ],
        'ciencias' => [
            'titulo' => 'Ciencias Naturales',
            'descripcion' => 'Biología, química y física',
            'temas' => [
                'biologia' => [
                    'titulo' => 'Biología',
                    'descripcion' => 'Estudio de los seres vivos',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'La Célula',
                            'texto' => 'La célula es la unidad básica de la vida. Todos los seres vivos están formados por células.'
                        ],
                        [
                            'tipo' => 'concepto',
                            'titulo' => 'Tipos de Células',
                            'texto' => 'Existen dos tipos principales: células procariotas (sin núcleo definido) y células eucariotas (con núcleo definido).'
                        ]
                    ]
                ],
                'quimica' => [
                    'titulo' => 'Química',
                    'descripcion' => 'Materia, elementos y reacciones',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'Tabla Periódica',
                            'texto' => 'La tabla periódica organiza los elementos químicos según sus propiedades.'
                        ]
                    ]
                ],
                'fisica' => [
                    'titulo' => 'Física',
                    'descripcion' => 'Movimiento, energía y fuerzas',
                    'contenido' => [
                        [
                            'tipo' => 'introduccion',
                            'titulo' => 'Leyes de Newton',
                            'texto' => 'Las tres leyes de Newton describen la relación entre el movimiento de un objeto y las fuerzas que actúan sobre él.'
                        ]
                    ]
                ]
            ]
        ]
    ];

    /**
     * Muestra el índice de materias
     */
    public function index()
    {
        return view('contenidos.index', [
            'materias' => $this->contenido
        ]);
    }

    /**
     * Muestra una materia específica
     */
    public function mostrarMateria($materia)
    {
        if (!isset($this->contenido[$materia])) {
            abort(404, 'Materia no encontrada');
        }

        return view('contenidos.materia', [
            'materia' => $materia,
            'datos' => $this->contenido[$materia]
        ]);
    }

    /**
     * Muestra un tema específico de una materia
     */
    public function mostrarTema($materia, $tema)
    {
        if (!isset($this->contenido[$materia]['temas'][$tema])) {
            abort(404, 'Tema no encontrado');
        }

        return view('contenidos.tema', [
            'materia' => $materia,
            'materiaDatos' => $this->contenido[$materia],
            'tema' => $tema,
            'temaDatos' => $this->contenido[$materia]['temas'][$tema]
        ]);
    }
}