// ====================================
// EDUSYSTEM - AUTHENTICATION SYSTEM (Laravel Adaptado)
// ====================================

// Inicializa datos demo
function initializeData() {
    if (!localStorage.getItem('users')) {
        const defaultUsers = [
            {
                id: 1,
                name: 'Administrador Demo',
                email: 'admin@edu.com',
                password: 'admin123',
                role: 'admin',
                createdAt: new Date().toISOString()
            },
            {
                id: 2,
                name: 'Profesor Demo',
                email: 'prof@edu.com',
                password: 'prof123',
                role: 'profesor',
                createdAt: new Date().toISOString()
            },
            {
                id: 3,
                name: 'Estudiante Demo',
                email: 'est@edu.com',
                password: 'est123',
                role: 'estudiante',
                createdAt: new Date().toISOString()
            }
        ];
        localStorage.setItem('users', JSON.stringify(defaultUsers));
        localStorage.setItem('courses', JSON.stringify([]));
        localStorage.setItem('tests', JSON.stringify([]));
        localStorage.setItem('questions', JSON.stringify([]));
        localStorage.setItem('results', JSON.stringify([]));
        console.log('✅ Demo data initialized');
    }
}

initializeData();

// ====================================
// AUTHENTICATION FUNCTIONS
// ====================================

function register(name, email, password, role) {
    try {
        const users = JSON.parse(localStorage.getItem('users')) || [];

        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(email)) {
            return { success: false, message: 'Correo electrónico no válido' };
        }

        if (users.some(u => u.email === email)) {
            return { success: false, message: 'Este correo ya está registrado' };
        }

        if (!['estudiante', 'profesor'].includes(role)) {
            return { success: false, message: 'Rol no válido' };
        }

        const newUser = {
            id: users.length + 1,
            name: name.trim(),
            email: email.toLowerCase().trim(),
            password: password,
            role: role,
            createdAt: new Date().toISOString()
        };

        users.push(newUser);
        localStorage.setItem('users', JSON.stringify(users));

        return { success: true, message: 'Cuenta creada. Redirigiendo al login...' };
    } catch (error) {
        console.error(error);
        return { success: false, message: 'Error al registrar usuario.' };
    }
}

function login(email, password) {
    try {
        const users = JSON.parse(localStorage.getItem('users')) || [];
        const user = users.find(u =>
            u.email.toLowerCase() === email.toLowerCase().trim() &&
            u.password === password
        );

        if (!user) {
            return { success: false, message: 'Correo o contraseña incorrectos' };
        }

        const userSession = {
            id: user.id,
            name: user.name,
            email: user.email,
            role: user.role
        };

        localStorage.setItem('currentUser', JSON.stringify(userSession));

        // 🔄 Rutas adaptadas a Laravel
        let redirect = '/dashboard/estudiantes';
        if (user.role === 'admin') {
            redirect = '/dashboard/admin';
        } else if (user.role === 'profesor') {
            redirect = '/dashboard/profesor';
        }

        return {
            success: true,
            message: '¡Bienvenido! Redirigiendo...',
            redirect: redirect,
            user: userSession
        };
    } catch (error) {
        console.error(error);
        return { success: false, message: 'Error al iniciar sesión.' };
    }
}

function logout() {
    localStorage.removeItem('currentUser');
    window.location.href = '/login';
}

function isLoggedIn() {
    return localStorage.getItem('currentUser') !== null;
}

function getCurrentUser() {
    const userStr = localStorage.getItem('currentUser');
    return userStr ? JSON.parse(userStr) : null;
}

function requireAuth(allowedRoles = []) {
    const user = getCurrentUser();

    if (!user) {
        window.location.href = '/login';
        return null;
    }

    if (allowedRoles.length > 0 && !allowedRoles.includes(user.role)) {
        alert('No tienes permiso para acceder a esta página');
        window.location.href = `/dashboard/${user.role}`;
        return null;
    }

    return user;
}

console.log('🔐 Auth System (Laravel) Loaded');
