// ====================================
// EDUSYSTEM - SEED DATA (DATOS DEMO)
// ====================================

function initializeSeedData() {
    // Solo inicializar si no hay datos (primera vez)
    const courses = JSON.parse(localStorage.getItem('courses')) || [];
    
    // Si ya hay cursos, no reinicializar
    if (courses.length > 0) {
        console.log('📚 Los datos ya existen, no se reinicializarán');
        return;
    }
    
    console.log('🌱 Inicializando datos de ejemplo...');
    
    // ===== CURSOS =====
    const demoCourses = [
        {
            id: 1,
            name: 'Matemáticas Básicas',
            description: 'Curso introductorio de matemáticas con álgebra y geometría básica',
            teacherId: 2, // Profesor Demo
            createdAt: new Date('2024-01-15').toISOString()
        },
        {
            id: 2,
            name: 'Historia Universal',
            description: 'Recorrido por los eventos más importantes de la historia mundial',
            teacherId: 2,
            createdAt: new Date('2024-01-20').toISOString()
        },
        {
            id: 3,
            name: 'Ciencias Naturales',
            description: 'Introducción a la biología, química y física',
            teacherId: 2,
            createdAt: new Date('2024-02-01').toISOString()
        },
        {
            id: 4,
            name: 'Programación Web',
            description: 'Fundamentos de HTML, CSS y JavaScript para desarrollo web',
            teacherId: 2,
            createdAt: new Date('2024-02-10').toISOString()
        },
        {
            id: 5,
            name: 'Literatura Española',
            description: 'Análisis de obras clásicas de la literatura española',
            teacherId: 2,
            createdAt: new Date('2024-02-15').toISOString()
        }
    ];
    
    // ===== PRUEBAS =====
    const demoTests = [
        {
            id: 1,
            title: 'Examen de Álgebra - Unidad 1',
            courseId: 1,
            deadline: new Date('2025-12-31').toISOString(),
            createdAt: new Date('2024-03-01').toISOString()
        },
        {
            id: 2,
            title: 'Quiz de Geometría',
            courseId: 1,
            deadline: null,
            createdAt: new Date('2024-03-05').toISOString()
        },
        {
            id: 3,
            title: 'Evaluación: Primera Guerra Mundial',
            courseId: 2,
            deadline: new Date('2025-11-30').toISOString(),
            createdAt: new Date('2024-03-10').toISOString()
        },
        {
            id: 4,
            title: 'Test: Civilizaciones Antiguas',
            courseId: 2,
            deadline: null,
            createdAt: new Date('2024-03-12').toISOString()
        },
        {
            id: 5,
            title: 'Examen: Sistema Solar',
            courseId: 3,
            deadline: new Date('2025-12-15').toISOString(),
            createdAt: new Date('2024-03-15').toISOString()
        },
        {
            id: 6,
            title: 'Quiz: Célula y sus partes',
            courseId: 3,
            deadline: null,
            createdAt: new Date('2024-03-18').toISOString()
        },
        {
            id: 7,
            title: 'Evaluación HTML y CSS',
            courseId: 4,
            deadline: new Date('2025-12-20').toISOString(),
            createdAt: new Date('2024-03-20').toISOString()
        },
        {
            id: 8,
            title: 'Test: El Quijote',
            courseId: 5,
            deadline: null,
            createdAt: new Date('2024-03-22').toISOString()
        }
    ];
    
    // ===== PREGUNTAS =====
    const demoQuestions = [
        // Preguntas de Álgebra
        {
            id: 1,
            testId: 1,
            question: '¿Cuál es el resultado de 2x + 3 = 11?',
            type: 'multiple',
            options: [
                { text: 'x = 3', isCorrect: false },
                { text: 'x = 4', isCorrect: true },
                { text: 'x = 5', isCorrect: false },
                { text: 'x = 6', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 2,
            testId: 1,
            question: '¿La ecuación x² = 16 tiene como soluciones x = 4 y x = -4?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 3,
            testId: 1,
            question: '¿Cuál es el resultado de (3 + 5) × 2?',
            type: 'multiple',
            options: [
                { text: '11', isCorrect: false },
                { text: '13', isCorrect: false },
                { text: '16', isCorrect: true },
                { text: '18', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de Geometría
        {
            id: 4,
            testId: 2,
            question: '¿Cuántos grados tiene un triángulo equilátero en cada ángulo?',
            type: 'multiple',
            options: [
                { text: '45°', isCorrect: false },
                { text: '60°', isCorrect: true },
                { text: '90°', isCorrect: false },
                { text: '120°', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 5,
            testId: 2,
            question: '¿Un cuadrado tiene 4 lados iguales?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de Historia - Primera Guerra Mundial
        {
            id: 6,
            testId: 3,
            question: '¿En qué año comenzó la Primera Guerra Mundial?',
            type: 'multiple',
            options: [
                { text: '1912', isCorrect: false },
                { text: '1914', isCorrect: true },
                { text: '1916', isCorrect: false },
                { text: '1918', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 7,
            testId: 3,
            question: '¿La Primera Guerra Mundial duró 4 años?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 8,
            testId: 3,
            question: '¿Quién fue asesinado en Sarajevo, desencadenando la guerra?',
            type: 'multiple',
            options: [
                { text: 'Kaiser Guillermo II', isCorrect: false },
                { text: 'Archiduque Francisco Fernando', isCorrect: true },
                { text: 'Zar Nicolás II', isCorrect: false },
                { text: 'Winston Churchill', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de Civilizaciones Antiguas
        {
            id: 9,
            testId: 4,
            question: '¿Las pirámides de Giza están en Egipto?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 10,
            testId: 4,
            question: '¿Cuál era la capital del Imperio Romano?',
            type: 'multiple',
            options: [
                { text: 'Atenas', isCorrect: false },
                { text: 'Roma', isCorrect: true },
                { text: 'Esparta', isCorrect: false },
                { text: 'Cartago', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de Sistema Solar
        {
            id: 11,
            testId: 5,
            question: '¿Cuántos planetas hay en el Sistema Solar?',
            type: 'multiple',
            options: [
                { text: '7', isCorrect: false },
                { text: '8', isCorrect: true },
                { text: '9', isCorrect: false },
                { text: '10', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 12,
            testId: 5,
            question: '¿El Sol es una estrella?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 13,
            testId: 5,
            question: '¿Cuál es el planeta más cercano al Sol?',
            type: 'multiple',
            options: [
                { text: 'Venus', isCorrect: false },
                { text: 'Mercurio', isCorrect: true },
                { text: 'Tierra', isCorrect: false },
                { text: 'Marte', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de Célula
        {
            id: 14,
            testId: 6,
            question: '¿La mitocondria es conocida como la "central energética" de la célula?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 15,
            testId: 6,
            question: '¿Qué estructura controla las actividades de la célula?',
            type: 'multiple',
            options: [
                { text: 'Membrana celular', isCorrect: false },
                { text: 'Núcleo', isCorrect: true },
                { text: 'Citoplasma', isCorrect: false },
                { text: 'Ribosoma', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de HTML y CSS
        {
            id: 16,
            testId: 7,
            question: '¿HTML significa HyperText Markup Language?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 17,
            testId: 7,
            question: '¿Qué etiqueta se usa para crear un enlace en HTML?',
            type: 'multiple',
            options: [
                { text: '<link>', isCorrect: false },
                { text: '<a>', isCorrect: true },
                { text: '<href>', isCorrect: false },
                { text: '<url>', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 18,
            testId: 7,
            question: '¿CSS se usa para dar estilo a las páginas web?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        
        // Preguntas de El Quijote
        {
            id: 19,
            testId: 8,
            question: '¿Quién escribió "Don Quijote de la Mancha"?',
            type: 'multiple',
            options: [
                { text: 'Federico García Lorca', isCorrect: false },
                { text: 'Miguel de Cervantes', isCorrect: true },
                { text: 'Pablo Neruda', isCorrect: false },
                { text: 'Gabriel García Márquez', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        },
        {
            id: 20,
            testId: 8,
            question: '¿El Quijote confunde molinos de viento con gigantes?',
            type: 'boolean',
            options: [
                { text: 'Verdadero', isCorrect: true },
                { text: 'Falso', isCorrect: false }
            ],
            createdAt: new Date().toISOString()
        }
    ];
    
    // ===== ALGUNOS RESULTADOS DE EJEMPLO =====
    const demoResults = [
        {
            id: 1,
            userId: 3, // Estudiante Demo
            testId: 2,
            score: 100,
            correctAnswers: 2,
            totalQuestions: 2,
            completedAt: new Date('2024-10-15').toISOString()
        },
        {
            id: 2,
            userId: 3,
            testId: 4,
            score: 50,
            correctAnswers: 1,
            totalQuestions: 2,
            completedAt: new Date('2024-10-18').toISOString()
        },
        {
            id: 3,
            userId: 3,
            testId: 6,
            score: 100,
            correctAnswers: 2,
            totalQuestions: 2,
            completedAt: new Date('2024-10-20').toISOString()
        }
    ];
    
    // Guardar todos los datos
    localStorage.setItem('courses', JSON.stringify(demoCourses));
    localStorage.setItem('tests', JSON.stringify(demoTests));
    localStorage.setItem('questions', JSON.stringify(demoQuestions));
    localStorage.setItem('results', JSON.stringify(demoResults));
    
    console.log('✅ Datos de ejemplo inicializados correctamente:');
    console.log(`   📚 ${demoCourses.length} cursos`);
    console.log(`   📝 ${demoTests.length} pruebas`);
    console.log(`   ❓ ${demoQuestions.length} preguntas`);
    console.log(`   📊 ${demoResults.length} resultados`);
}

// Ejecutar automáticamente al cargar
initializeSeedData();