<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $datos['titulo'] }} - EduSystem</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
        }
        
        .navbar-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .navbar-custom .navbar-brand {
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
        }
        
        .navbar-custom .nav-link {
            color: rgba(255,255,255,0.9);
            margin: 0 10px;
        }
        
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 60px 0;
        }
        
        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .breadcrumb-custom {
            background: white;
            padding: 15px 30px;
            border-radius: 10px;
            margin: 20px 0;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }
        
        .breadcrumb-custom a {
            color: #667eea;
            text-decoration: none;
        }
        
        .content-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 15px;
        }
        
        .topics-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }
        
        .topic-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: all 0.3s;
            text-decoration: none;
            color: inherit;
            border-left: 5px solid #667eea;
        }
        
        .topic-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.2);
        }
        
        .topic-card h3 {
            color: #333;
            font-weight: 600;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .topic-card h3 i {
            color: #667eea;
        }
        
        .topic-card p {
            color: #666;
            margin-bottom: 20px;
        }
        
        .topic-meta {
            display: flex;
            gap: 20px;
            font-size: 0.9rem;
            color: #999;
        }
        
        .topic-meta span {
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .btn-back {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: white;
            color: #667eea;
            border: 2px solid #667eea;
            padding: 12px 24px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-back:hover {
            background: #667eea;
            color: white;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container">
            <a class="navbar-brand" href="{{ route('cursos.index') }}">
                <i class="fas fa-graduation-cap"></i> EduSystem
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('cursos.index') }}">
                            <i class="fas fa-book"></i> Cursos
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('dashboard.estudiantes') }}">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Page Header -->
    <div class="page-header">
        <div class="container">
            <h1>
                @if($materia === 'matematicas')
                    <i class="fas fa-calculator"></i>
                @elseif($materia === 'lenguaje')
                    <i class="fas fa-pen-fancy"></i>
                @elseif($materia === 'ciencias')
                    <i class="fas fa-flask"></i>
                @endif
                {{ $datos['titulo'] }}
            </h1>
            <p>{{ $datos['descripcion'] }}</p>
        </div>
    </div>

    <!-- Content -->
    <div class="content-container">
        <!-- Breadcrumb -->
        <div class="breadcrumb-custom">
            <a href="{{ route('cursos.index') }}">Cursos</a> /
            <strong>{{ $datos['titulo'] }}</strong>
        </div>

        <a href="{{ route('cursos.index') }}" class="btn-back">
            <i class="fas fa-arrow-left"></i> Volver a Cursos
        </a>

        <!-- Topics Grid -->
        <div class="topics-grid">
            @foreach($datos['temas'] as $temaKey => $tema)
                <a href="{{ route('cursos.tema', [$materia, $temaKey]) }}" class="topic-card">
                    <h3>
                        <i class="fas fa-book-open"></i>
                        {{ $tema['titulo'] }}
                    </h3>
                    <p>{{ $tema['descripcion'] }}</p>
                    <div class="topic-meta">
                        <span>
                            <i class="fas fa-list"></i>
                            {{ count($tema['contenido']) }} secciones
                        </span>
                        @if(isset($tema['recursos']))
                            <span>
                                <i class="fas fa-folder"></i>
                                {{ count($tema['recursos']) }} recursos
                            </span>
                        @endif
                    </div>
                </a>
            @endforeach
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>