<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - EduSystem</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: 260px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            color: white;
            overflow-y: auto;
            z-index: 1000;
            transition: all 0.3s;
        }
        
        .sidebar-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.2);
        }
        
        .sidebar-header i {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .sidebar-header h4 {
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .sidebar-header p {
            font-size: 0.85rem;
            opacity: 0.8;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 0;
        }
        
        .sidebar-menu li {
            margin-bottom: 5px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            color: white;
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: rgba(255,255,255,0.2);
            transform: translateX(5px);
        }
        
        .sidebar-menu i {
            margin-right: 10px;
            width: 20px;
        }
        
        .logout-btn {
            margin-top: 20px;
            padding: 12px;
            background: rgba(255,255,255,0.1);
            border: none;
            color: white;
            border-radius: 10px;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.2);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 30px;
            min-height: 100vh;
        }
        
        .top-bar {
            background: white;
            padding: 20px 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .top-bar h2 {
            margin: 0;
            color: #333;
            font-weight: 700;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        
        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .stat-info h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 5px;
            color: #333;
        }
        
        .stat-info p {
            color: #999;
            margin: 0;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
        }
        
        .stat-icon.blue {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .stat-icon.purple {
            background: rgba(118, 75, 162, 0.1);
            color: #764ba2;
        }
        
        .stat-icon.green {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .stat-icon.orange {
            background: rgba(255, 193, 7, 0.1);
            color: #ffc107;
        }
        
        /* Content Sections */
        .content-section {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .section-header h3 {
            margin: 0;
            color: #333;
            font-weight: 600;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 10px 20px;
            border-radius: 10px;
            color: white;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        /* Table */
        .custom-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
        }
        
        .custom-table thead th {
            background: #f8f9fa;
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #666;
            border: none;
        }
        
        .custom-table tbody tr {
            background: white;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .custom-table tbody tr:hover {
            transform: translateX(5px);
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        
        .custom-table tbody td {
            padding: 15px;
            border: none;
        }
        
        .custom-table tbody tr td:first-child {
            border-radius: 10px 0 0 10px;
        }
        
        .custom-table tbody tr td:last-child {
            border-radius: 0 10px 10px 0;
        }
        
        .badge-role {
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
        }
        
        .badge-admin {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }
        
        .badge-profesor {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .badge-estudiante {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .action-btn {
            padding: 5px 10px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            margin: 0 2px;
            transition: all 0.3s;
        }
        
        .action-btn.edit {
            background: rgba(255, 193, 7, 0.1);
            color: #ffc107;
        }
        
        .action-btn.delete {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }
        
        .action-btn:hover {
            transform: scale(1.1);
        }
        
        /* Modal Custom */
        .modal-content {
            border-radius: 15px;
            border: none;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            border: none;
        }
        
        .form-control, .form-select {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 10px 15px;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                width: 70px;
            }
            
            .sidebar-header h4,
            .sidebar-header p,
            .sidebar-menu span {
                display: none;
            }
            
            .main-content {
                margin-left: 70px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-graduation-cap"></i>
            <h4>EduSystem</h4>
            <p id="userRole">Administrador</p>
        </div>
        
        <ul class="sidebar-menu">
            <li><a href="#" class="active" onclick="showSection('dashboard')"><i class="fas fa-home"></i> <span>Dashboard</span></a></li>
            <li><a href="#" onclick="showSection('courses')"><i class="fas fa-book"></i> <span>Cursos</span></a></li>
            <li><a href="#" onclick="showSection('users')"><i class="fas fa-users"></i> <span>Usuarios</span></a></li>
            <li><a href="#" onclick="showSection('settings')"><i class="fas fa-cog"></i> <span>Configuración</span></a></li>
        </ul>
        
        <button class="logout-btn" onclick="logout()">
            <i class="fas fa-sign-out-alt"></i> <span>Cerrar Sesión</span>
        </button>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <div class="top-bar">
            <h2 id="pageTitle">Dashboard</h2>
            <div class="user-info">
                <div class="user-avatar" id="userAvatar">A</div>
                <div>
                    <strong id="userName">Admin</strong>
                    <p style="margin: 0; font-size: 0.85rem; color: #999;">Administrador</p>
                </div>
            </div>
        </div>

        <!-- Dashboard Section -->
        <div id="dashboardSection">
            <!-- Stats Cards -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="totalCourses">0</h3>
                        <p>Total Cursos</p>
                    </div>
                    <div class="stat-icon blue">
                        <i class="fas fa-book"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="totalUsers">3</h3>
                        <p>Total Usuarios</p>
                    </div>
                    <div class="stat-icon purple">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="totalTests">0</h3>
                        <p>Total Pruebas</p>
                    </div>
                    <div class="stat-icon green">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="totalResults">0</h3>
                        <p>Resultados</p>
                    </div>
                    <div class="stat-icon orange">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-clock"></i> Actividad Reciente</h3>
                </div>
                <div id="recentActivity">
                    <p style="text-align: center; color: #999; padding: 20px;">
                        <i class="fas fa-info-circle"></i> No hay actividad reciente
                    </p>
                </div>
            </div>
        </div>

        <!-- Courses Section -->
        <div id="coursesSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-book"></i> Gestión de Cursos</h3>
                    <button class="btn-primary-custom" onclick="openCourseModal()">
                        <i class="fas fa-plus"></i> Nuevo Curso
                    </button>
                </div>
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nombre del Curso</th>
                            <th>Descripción</th>
                            <th>Profesor</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="coursesTableBody">
                        <tr>
                            <td colspan="5" style="text-align: center; color: #999;">
                                No hay cursos creados
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Users Section -->
        <div id="usersSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-users"></i> Gestión de Usuarios</h3>
                </div>
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Email</th>
                            <th>Rol</th>
                            <th>Fecha Registro</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="usersTableBody">
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Settings Section -->
        <div id="settingsSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-cog"></i> Configuración del Sistema</h3>
                </div>
                
                <div class="mb-4">
                    <h5>Perfil de Usuario</h5>
                    <form id="profileForm" class="mt-3">
                        <div class="mb-3">
                            <label class="form-label">Nombre Completo</label>
                            <input type="text" class="form-control" id="profileName" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" id="profileEmail" required>
                        </div>
                        <button type="submit" class="btn-primary-custom">
                            <i class="fas fa-save"></i> Guardar Cambios
                        </button>
                    </form>
                </div>
                
                <hr class="my-4">
                
                <div>
                    <h5>Administración del Sistema</h5>
                    <button class="btn btn-danger mt-3" onclick="resetAllData()">
                        <i class="fas fa-trash"></i> Reiniciar Todos los Datos
                    </button>
                    <p class="text-muted mt-2" style="font-size: 0.85rem;">
                        <i class="fas fa-exclamation-triangle"></i> Esto eliminará todos los cursos, pruebas y resultados
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Nuevo Curso -->
    <div class="modal fade" id="courseModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-book"></i> Nuevo Curso</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="courseForm">
                        <div class="mb-3">
                            <label class="form-label">Nombre del Curso</label>
                            <input type="text" class="form-control" id="courseName" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Descripción</label>
                            <textarea class="form-control" id="courseDescription" rows="3" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Asignar Profesor</label>
                            <select class="form-select" id="courseTeacher" required>
                                <option value="">Seleccionar profesor...</option>
                            </select>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn-primary-custom" onclick="saveCourse()">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auth JS -->
    <script src="../assets/js/auth.js"></script>
    <!-- Data -->
    <script src="../assets/js/data.js"></script>
    
    <script>
        // Check authentication
        const currentUser = requireAuth(['admin']);
        
        if (currentUser) {
            document.getElementById('userName').textContent = currentUser.name;
            document.getElementById('userAvatar').textContent = currentUser.name.charAt(0).toUpperCase();
            document.getElementById('profileName').value = currentUser.name;
            document.getElementById('profileEmail').value = currentUser.email;
        }
        
        // Load initial data
        loadDashboardStats();
        loadUsers();
        loadCourses();
        loadTeachersForSelect();
        
        // Show section
        function showSection(section) {
            // Hide all sections
            document.getElementById('dashboardSection').style.display = 'none';
            document.getElementById('coursesSection').style.display = 'none';
            document.getElementById('usersSection').style.display = 'none';
            document.getElementById('settingsSection').style.display = 'none';
            
            // Show selected section
            if (section === 'dashboard') {
                document.getElementById('dashboardSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Dashboard';
            } else if (section === 'courses') {
                document.getElementById('coursesSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Gestión de Cursos';
                loadCourses();
            } else if (section === 'users') {
                document.getElementById('usersSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Gestión de Usuarios';
                loadUsers();
            } else if (section === 'settings') {
                document.getElementById('settingsSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Configuración';
            }
            
            // Update active menu
            document.querySelectorAll('.sidebar-menu a').forEach(a => a.classList.remove('active'));
            event.target.closest('a').classList.add('active');
        }
        
        // Load dashboard stats
        function loadDashboardStats() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const users = JSON.parse(localStorage.getItem('users')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const results = JSON.parse(localStorage.getItem('results')) || [];
            
            document.getElementById('totalCourses').textContent = courses.length;
            document.getElementById('totalUsers').textContent = users.length;
            document.getElementById('totalTests').textContent = tests.length;
            document.getElementById('totalResults').textContent = results.length;
        }
        
        // Load users
        function loadUsers() {
            const users = getAllUsers();
            const tbody = document.getElementById('usersTableBody');
            
            tbody.innerHTML = users.map(user => `
                <tr>
                    <td>${user.id}</td>
                    <td>${user.name}</td>
                    <td>${user.email}</td>
                    <td>
                        <span class="badge-role badge-${user.role}">
                            ${user.role === 'admin' ? 'Administrador' : user.role === 'profesor' ? 'Profesor' : 'Estudiante'}
                        </span>
                    </td>
                    <td>${new Date(user.createdAt).toLocaleDateString()}</td>
                    <td>
                        ${user.id !== currentUser.id ? `
                            <button class="action-btn delete" onclick="deleteUserConfirm(${user.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        ` : '<small class="text-muted">Tu cuenta</small>'}
                    </td>
                </tr>
            `).join('');
        }
        
        // Delete user with confirmation
        function deleteUserConfirm(userId) {
            if (confirm('¿Estás seguro de eliminar este usuario?')) {
                const result = deleteUser(userId);
                if (result.success) {
                    alert(result.message);
                    loadUsers();
                    loadDashboardStats();
                } else {
                    alert(result.message);
                }
            }
        }
        
        // Load courses
        function loadCourses() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const users = JSON.parse(localStorage.getItem('users')) || [];
            const tbody = document.getElementById('coursesTableBody');
            
            if (courses.length === 0) {
                tbody.innerHTML = '<tr><td colspan="5" style="text-align: center; color: #999;">No hay cursos creados</td></tr>';
                return;
            }
            
            tbody.innerHTML = courses.map(course => {
                const teacher = users.find(u => u.id === course.teacherId);
                return `
                    <tr>
                        <td>${course.id}</td>
                        <td><strong>${course.name}</strong></td>
                        <td>${course.description}</td>
                        <td>${teacher ? teacher.name : 'Sin asignar'}</td>
                        <td>
                            <button class="action-btn delete" onclick="deleteCourseConfirm(${course.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            }).join('');
        }
        
        // Load teachers for select
        function loadTeachersForSelect() {
            const users = JSON.parse(localStorage.getItem('users')) || [];
            const teachers = users.filter(u => u.role === 'profesor');
            const select = document.getElementById('courseTeacher');
            
            select.innerHTML = '<option value="">Seleccionar profesor...</option>' +
                teachers.map(t => `<option value="${t.id}">${t.name}</option>`).join('');
        }
        
        // Open course modal
        function openCourseModal() {
            const modal = new bootstrap.Modal(document.getElementById('courseModal'));
            document.getElementById('courseForm').reset();
            modal.show();
        }
        
        // Save course
        function saveCourse() {
            const name = document.getElementById('courseName').value;
            const description = document.getElementById('courseDescription').value;
            const teacherId = parseInt(document.getElementById('courseTeacher').value);
            
            if (!name || !description || !teacherId) {
                alert('Por favor completa todos los campos');
                return;
            }
            
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const newCourse = {
                id: courses.length + 1,
                name: name,
                description: description,
                teacherId: teacherId,
                createdAt: new Date().toISOString()
            };
            
            courses.push(newCourse);
            localStorage.setItem('courses', JSON.stringify(courses));
            
            bootstrap.Modal.getInstance(document.getElementById('courseModal')).hide();
            alert('Curso creado exitosamente');
            loadCourses();
            loadDashboardStats();
        }
        
        // Delete course
        function deleteCourseConfirm(courseId) {
            if (confirm('¿Estás seguro de eliminar este curso?')) {
                let courses = JSON.parse(localStorage.getItem('courses')) || [];
                courses = courses.filter(c => c.id !== courseId);
                localStorage.setItem('courses', JSON.stringify(courses));
                alert('Curso eliminado');
                loadCourses();
                loadDashboardStats();
            }
        }
        
        // Update profile
        document.getElementById('profileForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const name = document.getElementById('profileName').value;
            const email = document.getElementById('profileEmail').value;
            
            const result = updateProfile(name, email);
            alert(result.message);
            
            if (result.success) {
                document.getElementById('userName').textContent = name;
                document.getElementById('userAvatar').textContent = name.charAt(0).toUpperCase();
            }
        });
    </script>
    
</body>
</html>