<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Profesor - EduSystem</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: 260px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            color: white;
            overflow-y: auto;
            z-index: 1000;
            transition: all 0.3s;
        }
        
        .sidebar-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.2);
        }
        
        .sidebar-header i {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .sidebar-header h4 {
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .sidebar-header p {
            font-size: 0.85rem;
            opacity: 0.8;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 0;
        }
        
        .sidebar-menu li {
            margin-bottom: 5px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            color: white;
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: rgba(255,255,255,0.2);
            transform: translateX(5px);
        }
        
        .sidebar-menu i {
            margin-right: 10px;
            width: 20px;
        }
        
        .logout-btn {
            margin-top: 20px;
            padding: 12px;
            background: rgba(255,255,255,0.1);
            border: none;
            color: white;
            border-radius: 10px;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.2);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 30px;
            min-height: 100vh;
        }
        
        .top-bar {
            background: white;
            padding: 20px 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .top-bar h2 {
            margin: 0;
            color: #333;
            font-weight: 700;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        
        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .stat-info h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 5px;
            color: #333;
        }
        
        .stat-info p {
            color: #999;
            margin: 0;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
        }
        
        .stat-icon.blue {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .stat-icon.purple {
            background: rgba(118, 75, 162, 0.1);
            color: #764ba2;
        }
        
        .stat-icon.green {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        /* Content Sections */
        .content-section {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .section-header h3 {
            margin: 0;
            color: #333;
            font-weight: 600;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 10px 20px;
            border-radius: 10px;
            color: white;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }
        
        .course-card {
            background: white;
            border: 2px solid #f0f0f0;
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s;
        }
        
        .course-card:hover {
            border-color: #667eea;
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.2);
        }
        
        .course-card h4 {
            color: #333;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        .course-card p {
            color: #666;
            font-size: 0.9rem;
            margin-bottom: 15px;
        }
        
        .course-meta {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            font-size: 0.85rem;
            color: #999;
        }
        
        .course-meta span {
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .card-actions {
            display: flex;
            gap: 10px;
        }
        
        .card-actions button {
            flex: 1;
            padding: 8px;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-view {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .btn-view:hover {
            background: #667eea;
            color: white;
        }
        
        .btn-add {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .btn-add:hover {
            background: #28a745;
            color: white;
        }
        
        /* Table */
        .custom-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
        }
        
        .custom-table thead th {
            background: #f8f9fa;
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #666;
            border: none;
        }
        
        .custom-table tbody tr {
            background: white;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .custom-table tbody tr:hover {
            transform: translateX(5px);
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        
        .custom-table tbody td {
            padding: 15px;
            border: none;
        }
        
        .custom-table tbody tr td:first-child {
            border-radius: 10px 0 0 10px;
        }
        
        .custom-table tbody tr td:last-child {
            border-radius: 0 10px 10px 0;
        }
        
        .badge-type {
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
        }
        
        .badge-multiple {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .badge-boolean {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .action-btn {
            padding: 5px 10px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            margin: 0 2px;
            transition: all 0.3s;
        }
        
        .action-btn.delete {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }
        
        .action-btn:hover {
            transform: scale(1.1);
        }
        
        /* Modal Custom */
        .modal-content {
            border-radius: 15px;
            border: none;
        }
        
        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0;
            border: none;
        }
        
        .form-control, .form-select {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 10px 15px;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .option-item {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 10px;
            position: relative;
        }
        
        .option-item .btn-remove {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                width: 70px;
            }
            
            .sidebar-header h4,
            .sidebar-header p,
            .sidebar-menu span {
                display: none;
            }
            
            .main-content {
                margin-left: 70px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .cards-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-chalkboard-teacher"></i>
            <h4>EduSystem</h4>
            <p id="userRole">Profesor</p>
        </div>
        
        <ul class="sidebar-menu">
            <li><a href="#" class="active" onclick="showSection('dashboard')"><i class="fas fa-home"></i> <span>Dashboard</span></a></li>
            <li><a href="#" onclick="showSection('courses')"><i class="fas fa-book"></i> <span>Mis Cursos</span></a></li>
            <li><a href="#" onclick="showSection('tests')"><i class="fas fa-clipboard-list"></i> <span>Mis Pruebas</span></a></li>
            <li><a href="#" onclick="showSection('profile')"><i class="fas fa-user"></i> <span>Mi Perfil</span></a></li>
        </ul>
        
        <button class="logout-btn" onclick="logout()">
            <i class="fas fa-sign-out-alt"></i> <span>Cerrar Sesión</span>
        </button>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <div class="top-bar">
            <h2 id="pageTitle">Dashboard</h2>
            <div class="user-info">
                <div class="user-avatar" id="userAvatar">P</div>
                <div>
                    <strong id="userName">Profesor</strong>
                    <p style="margin: 0; font-size: 0.85rem; color: #999;">Profesor</p>
                </div>
            </div>
        </div>

        <!-- Dashboard Section -->
        <div id="dashboardSection">
            <!-- Stats Cards -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="myCourses">0</h3>
                        <p>Mis Cursos</p>
                    </div>
                    <div class="stat-icon blue">
                        <i class="fas fa-book"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="myTests">0</h3>
                        <p>Mis Pruebas</p>
                    </div>
                    <div class="stat-icon purple">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="myQuestions">0</h3>
                        <p>Preguntas Creadas</p>
                    </div>
                    <div class="stat-icon green">
                        <i class="fas fa-question-circle"></i>
                    </div>
                </div>
            </div>

            <!-- Quick Access -->
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-star"></i> Acceso Rápido</h3>
                </div>
                <div id="quickAccess">
                    <p style="text-align: center; color: #999; padding: 20px;">
                        <i class="fas fa-info-circle"></i> No tienes cursos asignados aún
                    </p>
                </div>
            </div>
        </div>

        <!-- Courses Section -->
        <div id="coursesSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-book"></i> Mis Cursos</h3>
                </div>
                <div class="cards-grid" id="coursesGrid">
                    <p style="text-align: center; color: #999; padding: 40px;">
                        No tienes cursos asignados
                    </p>
                </div>
            </div>
        </div>

        <!-- Tests Section -->
        <div id="testsSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-clipboard-list"></i> Mis Pruebas</h3>
                    <button class="btn-primary-custom" onclick="openTestModal()">
                        <i class="fas fa-plus"></i> Nueva Prueba
                    </button>
                </div>
                <div id="testsContainer">
                    <p style="text-align: center; color: #999; padding: 40px;">
                        No has creado pruebas aún
                    </p>
                </div>
            </div>
        </div>

        <!-- Profile Section -->
        <div id="profileSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-user"></i> Mi Perfil</h3>
                </div>
                
                <form id="profileForm">
                    <div class="mb-3">
                        <label class="form-label">Nombre Completo</label>
                        <input type="text" class="form-control" id="profileName" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" id="profileEmail" required>
                    </div>
                    <button type="submit" class="btn-primary-custom">
                        <i class="fas fa-save"></i> Guardar Cambios
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Nueva Prueba -->
    <div class="modal fade" id="testModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-clipboard-list"></i> Nueva Prueba</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="testForm">
                        <div class="mb-3">
                            <label class="form-label">Título de la Prueba</label>
                            <input type="text" class="form-control" id="testTitle" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Curso</label>
                            <select class="form-select" id="testCourse" required>
                                <option value="">Seleccionar curso...</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Fecha Límite (Opcional)</label>
                            <input type="date" class="form-control" id="testDeadline">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn-primary-custom" onclick="saveTest()">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Agregar Pregunta -->
    <div class="modal fade" id="questionModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-question-circle"></i> Agregar Pregunta</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="questionForm">
                        <input type="hidden" id="currentTestId">
                        <div class="mb-3">
                            <label class="form-label">Pregunta</label>
                            <textarea class="form-control" id="questionText" rows="3" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tipo de Pregunta</label>
                            <select class="form-select" id="questionType" onchange="updateOptionsSection()" required>
                                <option value="multiple">Opción Múltiple</option>
                                <option value="boolean">Verdadero/Falso</option>
                            </select>
                        </div>
                        <div id="optionsSection">
                            <label class="form-label">Opciones</label>
                            <div id="optionsContainer"></div>
                            <button type="button" class="btn btn-sm btn-outline-primary mt-2" onclick="addOption()">
                                <i class="fas fa-plus"></i> Agregar Opción
                            </button>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn-primary-custom" onclick="saveQuestion()">
                        <i class="fas fa-save"></i> Guardar Pregunta
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auth JS -->
    <script src="{{ asset('assets/js/auth.js') }}"></script>
    <!-- Data -->
    <script src="{{ asset('assets/js/data.js') }}"></script>
    
    <script>
        // Check authentication
        const currentUser = requireAuth(['profesor']);
        
        if (currentUser) {
            document.getElementById('userName').textContent = currentUser.name;
            document.getElementById('userAvatar').textContent = currentUser.name.charAt(0).toUpperCase();
            document.getElementById('profileName').value = currentUser.name;
            document.getElementById('profileEmail').value = currentUser.email;
        }
        
        let optionCounter = 0;
        
        // Load initial data
        loadDashboardStats();
        loadMyCourses();
        loadMyTests();
        
        // Show section
        function showSection(section) {
            document.getElementById('dashboardSection').style.display = 'none';
            document.getElementById('coursesSection').style.display = 'none';
            document.getElementById('testsSection').style.display = 'none';
            document.getElementById('profileSection').style.display = 'none';
            
            if (section === 'dashboard') {
                document.getElementById('dashboardSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Dashboard';
            } else if (section === 'courses') {
                document.getElementById('coursesSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Mis Cursos';
                loadMyCourses();
            } else if (section === 'tests') {
                document.getElementById('testsSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Mis Pruebas';
                loadMyTests();
            } else if (section === 'profile') {
                document.getElementById('profileSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Mi Perfil';
            }
            
            document.querySelectorAll('.sidebar-menu a').forEach(a => a.classList.remove('active'));
            if (event && event.target) {
                event.target.closest('a').classList.add('active');
            }
        }
        
        // Load dashboard stats
        function loadDashboardStats() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            
            const myCourses = courses.filter(c => c.teacherId === currentUser.id);
            const myTests = tests.filter(t => {
                const course = courses.find(c => c.id === t.courseId);
                return course && course.teacherId === currentUser.id;
            });
            
            document.getElementById('myCourses').textContent = myCourses.length;
            document.getElementById('myTests').textContent = myTests.length;
            document.getElementById('myQuestions').textContent = questions.length;
        }
        
        // Load my courses
        function loadMyCourses() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const myCourses = courses.filter(c => c.teacherId === currentUser.id);
            const grid = document.getElementById('coursesGrid');
            
            if (myCourses.length === 0) {
                grid.innerHTML = '<p style="text-align: center; color: #999; padding: 40px;">No tienes cursos asignados</p>';
                return;
            }
            
            grid.innerHTML = myCourses.map(course => {
                const courseTests = tests.filter(t => t.courseId === course.id);
                return `
                    <div class="course-card">
                        <h4>${course.name}</h4>
                        <p>${course.description}</p>
                        <div class="course-meta">
                            <span><i class="fas fa-clipboard-list"></i> ${courseTests.length} pruebas</span>
                        </div>
                        <div class="card-actions">
                            <button class="btn-view" onclick="viewCourseTests(${course.id})">
                                <i class="fas fa-eye"></i> Ver Pruebas
                            </button>
                            <button class="btn-add" onclick="openTestModalForCourse(${course.id})">
                                <i class="fas fa-plus"></i> Nueva Prueba
                            </button>
                        </div>
                    </div>
                `;
            }).join('');
        }
        
        // Load my tests
        function loadMyTests() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            
            const myCourses = courses.filter(c => c.teacherId === currentUser.id);
            const myCourseIds = myCourses.map(c => c.id);
            const myTests = tests.filter(t => myCourseIds.includes(t.courseId));
            
            const container = document.getElementById('testsContainer');
            
            // Populate course selector in test modal
            const courseSelect = document.getElementById('testCourse');
            courseSelect.innerHTML = '<option value="">Seleccionar curso...</option>' + 
                myCourses.map(c => `<option value="${c.id}">${c.name}</option>`).join('');
            
            if (myTests.length === 0) {
                container.innerHTML = '<p style="text-align: center; color: #999; padding: 40px;">No has creado pruebas aún</p>';
                return;
            }
            
            let html = '<table class="custom-table"><thead><tr><th>Prueba</th><th>Curso</th><th>Preguntas</th><th>Fecha Límite</th><th>Acciones</th></tr></thead><tbody>';
            
            myTests.forEach(test => {
                const course = courses.find(c => c.id === test.courseId);
                const testQuestions = questions.filter(q => q.testId === test.id);
                
                html += `
                    <tr>
                        <td><strong>${test.title}</strong></td>
                        <td>${course ? course.name : 'N/A'}</td>
                        <td>${testQuestions.length} preguntas</td>
                        <td>${test.deadline ? new Date(test.deadline).toLocaleDateString() : 'Sin fecha límite'}</td>
                        <td>
                            <button class="action-btn btn-view" onclick="viewQuestions(${test.id})" title="Ver preguntas">
                                <i class="fas fa-eye"></i>
                            </button>
                            <button class="action-btn btn-add" onclick="openQuestionModal(${test.id})" title="Agregar pregunta">
                                <i class="fas fa-plus"></i>
                            </button>
                            <button class="action-btn delete" onclick="deleteTest(${test.id})" title="Eliminar prueba">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            html += '</tbody></table>';
            container.innerHTML = html;
        }
        
        // View course tests
        function viewCourseTests(courseId) {
            showSection('tests');
        }
        
        // Open test modal
        function openTestModal() {
            const modal = new bootstrap.Modal(document.getElementById('testModal'));
            document.getElementById('testForm').reset();
            modal.show();
        }
        
        // Open test modal for specific course
        function openTestModalForCourse(courseId) {
            const modal = new bootstrap.Modal(document.getElementById('testModal'));
            document.getElementById('testForm').reset();
            document.getElementById('testCourse').value = courseId;
            modal.show();
        }
        
        // Save test
        function saveTest() {
            const title = document.getElementById('testTitle').value;
            const courseId = parseInt(document.getElementById('testCourse').value);
            const deadline = document.getElementById('testDeadline').value;
            
            if (!title || !courseId) {
                alert('Por favor completa todos los campos obligatorios');
                return;
            }
            
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const newTest = {
                id: tests.length + 1,
                title: title,
                courseId: courseId,
                deadline: deadline || null,
                createdAt: new Date().toISOString()
            };
            
            tests.push(newTest);
            localStorage.setItem('tests', JSON.stringify(tests));
            
            bootstrap.Modal.getInstance(document.getElementById('testModal')).hide();
            alert('Prueba creada exitosamente');
            loadMyTests();
            loadDashboardStats();
        }
        
        // Delete test
        function deleteTest(testId) {
            if (confirm('¿Estás seguro de eliminar esta prueba? También se eliminarán todas sus preguntas.')) {
                let tests = JSON.parse(localStorage.getItem('tests')) || [];
                let questions = JSON.parse(localStorage.getItem('questions')) || [];
                
                tests = tests.filter(t => t.id !== testId);
                questions = questions.filter(q => q.testId !== testId);
                
                localStorage.setItem('tests', JSON.stringify(tests));
                localStorage.setItem('questions', JSON.stringify(questions));
                
                alert('Prueba eliminada exitosamente');
                loadMyTests();
                loadDashboardStats();
            }
        }
        
        // Open question modal
        function openQuestionModal(testId) {
            document.getElementById('currentTestId').value = testId;
            document.getElementById('questionForm').reset();
            optionCounter = 0;
            updateOptionsSection();
            const modal = new bootstrap.Modal(document.getElementById('questionModal'));
            modal.show();
        }
        
        // Update options section based on question type
        function updateOptionsSection() {
            const type = document.getElementById('questionType').value;
            const container = document.getElementById('optionsContainer');
            optionCounter = 0;
            
            if (type === 'boolean') {
                container.innerHTML = `
                    <div class="option-item">
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="correctOption" id="optTrue" value="true" checked>
                            <label class="form-check-label" for="optTrue">
                                <strong>Verdadero</strong>
                            </label>
                        </div>
                    </div>
                    <div class="option-item">
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="correctOption" id="optFalse" value="false">
                            <label class="form-check-label" for="optFalse">
                                <strong>Falso</strong>
                            </label>
                        </div>
                    </div>
                `;
                document.getElementById('optionsSection').querySelector('.btn-outline-primary').style.display = 'none';
            } else {
                container.innerHTML = '';
                document.getElementById('optionsSection').querySelector('.btn-outline-primary').style.display = 'block';
                addOption();
                addOption();
            }
        }
        
        // Add option for multiple choice
        function addOption() {
            optionCounter++;
            const container = document.getElementById('optionsContainer');
            const optionHtml = `
                <div class="option-item" id="option${optionCounter}">
                    <button type="button" class="btn btn-sm btn-danger btn-remove" onclick="removeOption(${optionCounter})">
                        <i class="fas fa-times"></i>
                    </button>
                    <div class="mb-2">
                        <input type="text" class="form-control" placeholder="Texto de la opción" id="optText${optionCounter}" required>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="correctOption" id="optCorrect${optionCounter}" value="${optionCounter}">
                        <label class="form-check-label" for="optCorrect${optionCounter}">
                            Respuesta correcta
                        </label>
                    </div>
                </div>
            `;
            container.insertAdjacentHTML('beforeend', optionHtml);
        }
        
        // Remove option
        function removeOption(id) {
            const element = document.getElementById('option' + id);
            if (element) {
                element.remove();
            }
        }
        
        // Save question
        function saveQuestion() {
            const testId = parseInt(document.getElementById('currentTestId').value);
            const questionText = document.getElementById('questionText').value;
            const questionType = document.getElementById('questionType').value;
            
            if (!questionText) {
                alert('Por favor ingresa la pregunta');
                return;
            }
            
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            
            let options = [];
            if (questionType === 'boolean') {
                const correct = document.querySelector('input[name="correctOption"]:checked').value;
                options = [
                    { text: 'Verdadero', isCorrect: correct === 'true' },
                    { text: 'Falso', isCorrect: correct === 'false' }
                ];
            } else {
                const optionElements = document.querySelectorAll('#optionsContainer .option-item');
                if (optionElements.length < 2) {
                    alert('Debes agregar al menos 2 opciones');
                    return;
                }
                
                const correctOption = document.querySelector('input[name="correctOption"]:checked');
                if (!correctOption) {
                    alert('Debes seleccionar la respuesta correcta');
                    return;
                }
                
                optionElements.forEach((elem, index) => {
                    const input = elem.querySelector('input[type="text"]');
                    if (input && input.value) {
                        const id = input.id.replace('optText', '');
                        options.push({
                            text: input.value,
                            isCorrect: correctOption.value === id
                        });
                    }
                });
            }
            
            const newQuestion = {
                id: questions.length + 1,
                testId: testId,
                question: questionText,
                type: questionType,
                options: options,
                createdAt: new Date().toISOString()
            };
            
            questions.push(newQuestion);
            localStorage.setItem('questions', JSON.stringify(questions));
            
            bootstrap.Modal.getInstance(document.getElementById('questionModal')).hide();
            alert('Pregunta agregada exitosamente');
            loadMyTests();
            loadDashboardStats();
        }
        
        // View questions
        function viewQuestions(testId) {
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const testQuestions = questions.filter(q => q.testId === testId);
            const test = tests.find(t => t.id === testId);
            
            if (testQuestions.length === 0) {
                alert('Esta prueba no tiene preguntas aún');
                return;
            }
            
            let html = `
                <div class="mb-3">
                    <h4><i class="fas fa-clipboard-list"></i> ${test ? test.title : 'Prueba'}</h4>
                    <p class="text-muted">Total de preguntas: ${testQuestions.length}</p>
                </div>
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Pregunta</th>
                            <th>Tipo</th>
                            <th>Opciones</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
            `;
            
            testQuestions.forEach((q, index) => {
                const correctOption = q.options.find(o => o.isCorrect);
                html += `
                    <tr>
                        <td><strong>${index + 1}</strong></td>
                        <td>${q.question}</td>
                        <td><span class="badge-type badge-${q.type === 'multiple' ? 'multiple' : 'boolean'}">${q.type === 'multiple' ? 'Múltiple' : 'V/F'}</span></td>
                        <td>
                            ${q.options.map(o => `<div><small>${o.text} ${o.isCorrect ? '<strong class="text-success">✓</strong>' : ''}</small></div>`).join('')}
                        </td>
                        <td>
                            <button class="action-btn delete" onclick="deleteQuestion(${q.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            html += `
                    </tbody>
                </table>
                <button class="btn-primary-custom mt-3" onclick="loadMyTests()">
                    <i class="fas fa-arrow-left"></i> Volver a Pruebas
                </button>
            `;
            
            const testsContainer = document.getElementById('testsContainer');
            testsContainer.innerHTML = html;
        }
        
        // Delete question
        function deleteQuestion(questionId) {
            if (confirm('¿Estás seguro de eliminar esta pregunta?')) {
                let questions = JSON.parse(localStorage.getItem('questions')) || [];
                questions = questions.filter(q => q.id !== questionId);
                localStorage.setItem('questions', JSON.stringify(questions));
                alert('Pregunta eliminada');
                
                // Reload the current view
                const testId = parseInt(document.getElementById('currentTestId').value) || 
                              questions.find(q => q.id === questionId)?.testId;
                if (testId) {
                    viewQuestions(testId);
                } else {
                    loadMyTests();
                }
                loadDashboardStats();
            }
        }
        
        // Update profile
        document.getElementById('profileForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const name = document.getElementById('profileName').value;
            const email = document.getElementById('profileEmail').value;
            
            const result = updateProfile(name, email);
            alert(result.message);
            
            if (result.success) {
                document.getElementById('userName').textContent = name;
                document.getElementById('userAvatar').textContent = name.charAt(0).toUpperCase();
            }
        });
    </script>
    
</body>
</html>