<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrarse - EduSystem</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .register-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
            max-width: 500px;
            width: 100%;
            animation: fadeInUp 0.6s ease;
        }
        
        .register-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        
        .register-header i {
            font-size: 3rem;
            margin-bottom: 15px;
        }
        
        .register-header h2 {
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .register-header p {
            opacity: 0.9;
            font-size: 0.95rem;
        }
        
        .register-body {
            padding: 40px 30px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
        }
        
        .form-control, .form-select {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 12px 15px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .input-group-text {
            background: #f8f9fa;
            border: 2px solid #e0e0e0;
            border-right: none;
            border-radius: 10px 0 0 10px;
        }
        
        .input-group .form-control {
            border-left: none;
            border-radius: 0 10px 10px 0;
        }
        
        .btn-register {
            width: 100%;
            padding: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 10px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .btn-register:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.4);
        }
        
        .divider {
            text-align: center;
            margin: 25px 0;
            position: relative;
        }
        
        .divider::before {
            content: "";
            position: absolute;
            left: 0;
            top: 50%;
            width: 100%;
            height: 1px;
            background: #e0e0e0;
        }
        
        .divider span {
            background: white;
            padding: 0 15px;
            position: relative;
            color: #999;
            font-size: 0.9rem;
        }
        
        .back-home {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-home a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .back-home a:hover {
            color: #764ba2;
        }
        
        .alert {
            border-radius: 10px;
            border: none;
            animation: slideDown 0.3s ease;
        }
        
        .password-strength {
            height: 4px;
            border-radius: 2px;
            margin-top: 5px;
            transition: all 0.3s;
        }
        
        .password-strength.weak {
            background: #dc3545;
            width: 33%;
        }
        
        .password-strength.medium {
            background: #ffc107;
            width: 66%;
        }
        
        .password-strength.strong {
            background: #28a745;
            width: 100%;
        }
        
        .role-info {
            font-size: 0.85rem;
            color: #666;
            margin-top: 5px;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @media (max-width: 576px) {
            .register-container {
                margin: 10px;
            }
            
            .register-header {
                padding: 30px 20px;
            }
            
            .register-body {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    
    <div class="register-container">
        <div class="register-header">
            <i class="fas fa-user-plus"></i>
            <h2>EduSystem</h2>
            <p>Crear Nueva Cuenta</p>
        </div>
        
        <div class="register-body">
            <!-- Alert Messages -->
            <div id="alertContainer"></div>
            
            <!-- Register Form -->
            <form id="registerForm">
                <div class="form-group">
                    <label class="form-label">Nombre Completo</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-user"></i>
                        </span>
                        <input type="text" class="form-control" id="name" placeholder="Juan Pérez" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Correo Electrónico</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-envelope"></i>
                        </span>
                        <input type="email" class="form-control" id="email" placeholder="ejemplo@correo.com" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Contraseña</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input type="password" class="form-control" id="password" placeholder="••••••••" required minlength="6">
                    </div>
                    <div id="passwordStrength" class="password-strength"></div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Confirmar Contraseña</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input type="password" class="form-control" id="confirmPassword" placeholder="••••••••" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Tipo de Cuenta</label>
                    <select class="form-select" id="role" required>
                        <option value="">Selecciona un rol</option>
                        <option value="estudiante">👨‍🎓 Estudiante</option>
                        <option value="profesor">👨‍🏫 Profesor</option>
                    </select>
                    <div class="role-info" id="roleInfo"></div>
                </div>
                
                <button type="submit" class="btn btn-register">
                    <i class="fas fa-user-plus"></i> Crear Cuenta
                </button>
            </form>
            
            <div class="divider">
                <span>o</span>
            </div>
            
            <div class="text-center">
                <p class="mb-0">¿Ya tienes una cuenta? <a href="{{ route('login') }}" style="color: #667eea; font-weight: 600;">Iniciar Sesión</a></p>
            </div>
            
            <div class="back-home">
                <a href="{{ route('home') }}"><i class="fas fa-arrow-left"></i> Volver al inicio</a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auth JS -->
    <script src="{{ asset('assets/js/auth.js') }}"></script>
    <script src="{{ asset('assets/js/data.js') }}"></script>

    
    <script>
        // Password strength indicator
        document.getElementById('password').addEventListener('input', function() {
            const password = this.value;
            const strengthBar = document.getElementById('passwordStrength');
            
            if (password.length === 0) {
                strengthBar.className = 'password-strength';
                return;
            }
            
            let strength = 0;
            if (password.length >= 6) strength++;
            if (password.length >= 10) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^a-zA-Z\d]/.test(password)) strength++;
            
            if (strength <= 2) {
                strengthBar.className = 'password-strength weak';
            } else if (strength <= 4) {
                strengthBar.className = 'password-strength medium';
            } else {
                strengthBar.className = 'password-strength strong';
            }
        });
        
        // Role info
        document.getElementById('role').addEventListener('change', function() {
            const roleInfo = document.getElementById('roleInfo');
            const roleInfoText = {
                'estudiante': 'Podrás ver cursos, tomar pruebas y ver tus resultados.',
                'profesor': 'Podrás crear pruebas, agregar preguntas y revisar resultados.'
            };
            roleInfo.textContent = roleInfoText[this.value] || '';
        });
        
        // Handle register form
        document.getElementById('registerForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const name = document.getElementById('name').value;
            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;
            const confirmPassword = document.getElementById('confirmPassword').value;
            const role = document.getElementById('role').value;
            
            // Validate passwords match
            if (password !== confirmPassword) {
                showAlert('danger', 'Las contraseñas no coinciden');
                return;
            }
            
            // Validate password length
            if (password.length < 6) {
                showAlert('danger', 'La contraseña debe tener al menos 6 caracteres');
                return;
            }
            
            const result = register(name, email, password, role);
            
            if (result.success) {
                showAlert('success', result.message);
                setTimeout(() => {
                    window.location.href = "{{ route('login') }}";
                }, 1500);
            } else {
                showAlert('danger', result.message);
            }
        });
        
        // Show alert message
        function showAlert(type, message) {
            const alertContainer = document.getElementById('alertContainer');
            alertContainer.innerHTML = `
                <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            `;
        }
        
        // Check if already logged in
        if (isLoggedIn()) {
            const user = getCurrentUser();
            let redirectUrl = '';
            switch(user.role) {
                case 'admin':
                    redirectUrl = "{{ route('dashboard.admin') }}";
                    break;
                case 'profesor':
                    redirectUrl = "{{ route('dashboard.profesor') }}";
                    break;
                case 'estudiante':
                    redirectUrl = "{{ route('dashboard.estudiantes') }}";
                    break;
            }
            window.location.href = redirectUrl;
        }

    </script>
    
</body>
</html>