<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EduSystem - Sistema de Gestión Educativa</title>
    
    <meta property="og:image" content="/assets/img/logo_lineal.jpg" />
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            overflow-x: hidden;
        }
        
        .index-page {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        /* Navbar */
        .navbar {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            padding: 1rem 0;
        }
        
        .navbar-brand {
            color: white !important;
            font-weight: 700;
            font-size: 1.5rem;
        }
        
        .navbar-nav .nav-link {
            color: white !important;
            margin: 0 10px;
            transition: all 0.3s;
        }
        
        .navbar-nav .nav-link:hover {
            transform: translateY(-2px);
        }
        
        /* Hero Section */
        .hero-section {
            padding: 100px 0;
            color: white;
            text-align: center;
        }
        
        .hero-section h1 {
            font-size: 3.5rem;
            font-weight: 700;
            margin-bottom: 20px;
            animation: fadeInUp 1s ease;
        }
        
        .hero-section p {
            font-size: 1.3rem;
            margin-bottom: 40px;
            opacity: 0.9;
            animation: fadeInUp 1s ease 0.2s backwards;
        }
        
        .btn-hero {
            padding: 15px 40px;
            font-size: 1.1rem;
            border-radius: 50px;
            margin: 10px;
            transition: all 0.3s;
            animation: fadeInUp 1s ease 0.4s backwards;
        }
        
        .btn-hero:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        
        /* Features Section */
        .features-section {
            padding: 80px 0;
            background: white;
        }
        
        .feature-card {
            text-align: center;
            padding: 40px 20px;
            border-radius: 15px;
            transition: all 0.3s;
            height: 100%;
            background: white;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        }
        
        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.15);
        }
        
        .feature-icon {
            font-size: 3rem;
            margin-bottom: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .feature-card h3 {
            font-weight: 600;
            margin-bottom: 15px;
            color: #333;
        }
        
        .feature-card p {
            color: #666;
            line-height: 1.6;
        }
        
        /* Roles Section */
        .roles-section {
            padding: 80px 0;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .role-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 40px;
            text-align: center;
            transition: all 0.3s;
            border: 2px solid rgba(255, 255, 255, 0.2);
            height: 100%;
        }
        
        .role-card:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-10px);
        }
        
        .role-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .role-card h3 {
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .role-card ul {
            text-align: left;
            list-style: none;
            padding: 0;
        }
        
        .role-card ul li {
            padding: 8px 0;
            padding-left: 25px;
            position: relative;
        }
        
        .role-card ul li:before {
            content: "✓";
            position: absolute;
            left: 0;
            font-weight: bold;
        }
        
        /* Footer */
        footer {
            background: #2d3748;
            color: white;
            padding: 40px 0;
            text-align: center;
        }
        
        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .hero-section h1 {
                font-size: 2.5rem;
            }
            
            .hero-section p {
                font-size: 1.1rem;
            }
        }
    </style>
</head>
<body class="index-page">
    
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="/">
                <i class="fas fa-graduation-cap"></i> EduSystem
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#features">Características</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#roles">Roles</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('login') }}">
                            <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <h1>Sistema de Gestión Educativa</h1>
            <p>Gestiona cursos, pruebas y resultados de forma simple y eficiente</p>
            <div>
                <a href="{{ route('login') }}" class="btn btn-light btn-hero">
                    <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                </a>
                <a href="{{ route('register') }}" class="btn btn-outline-light btn-hero">
                    <i class="fas fa-user-plus"></i> Registrarse
                </a>
            </div>
        </div>
    </section>


    <!-- Features Section -->
    <section class="features-section" id="features">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Características Principales</h2>
                <p class="text-muted">Todo lo que necesitas para gestionar tu sistema educativo</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-book"></i>
                        </div>
                        <h3>Gestión de Cursos</h3>
                        <p>Crea y administra cursos de manera sencilla. Asigna profesores y organiza el contenido educativo.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-clipboard-list"></i>
                        </div>
                        <h3>Pruebas Interactivas</h3>
                        <p>Crea exámenes con preguntas de opción múltiple y verdadero/falso. Calificación automática.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <h3>Resultados en Tiempo Real</h3>
                        <p>Visualiza resultados instantáneamente. Estadísticas y reportes detallados de desempeño.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Roles Section -->
    <section class="roles-section" id="roles">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Roles del Sistema</h2>
                <p>Cada usuario tiene acceso a funcionalidades específicas</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="role-card">
                        <div class="role-icon">
                            <i class="fas fa-user-shield"></i>
                        </div>
                        <h3>Administrador</h3>
                        <ul>
                            <li>Crear y gestionar cursos</li>
                            <li>Asignar profesores</li>
                            <li>Ver estadísticas generales</li>
                            <li>Administrar usuarios</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="role-card">
                        <div class="role-icon">
                            <i class="fas fa-chalkboard-teacher"></i>
                        </div>
                        <h3>Profesor</h3>
                        <ul>
                            <li>Crear pruebas y exámenes</li>
                            <li>Agregar preguntas</li>
                            <li>Revisar resultados</li>
                            <li>Gestionar sus cursos</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="role-card">
                        <div class="role-icon">
                            <i class="fas fa-user-graduate"></i>
                        </div>
                        <h3>Estudiante</h3>
                        <ul>
                            <li>Ver cursos asignados</li>
                            <li>Tomar pruebas</li>
                            <li>Ver resultados</li>
                            <li>Historial de evaluaciones</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container">
            <p class="mb-0">&copy; 2025 EduSystem - Sistema de Gestión Educativa | Demo Version</p>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
</body>
</html>