<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\EvaluacionController;

// Página principal
Route::get('/', function () {
    return view('welcome'); 
})->name('home');

// Autenticación
Route::get('/login', function () {
    return view('login');
})->name('login');

Route::get('/register', function () {
    return view('register');
})->name('register');

// Dashboards
Route::get('/dashboard/admin', function () {
    return view('dashboard.admin');
})->name('dashboard.admin');

Route::get('/dashboard/profesor', function () {
    return view('dashboard.profesor');
})->name('dashboard.profesor');

Route::get('/dashboard/estudiantes', function () {
    return view('dashboard.estudiantes');
})->name('dashboard.estudiantes');

// Rutas de contenido educativo
Route::get('/cursos', [App\Http\Controllers\ContenidoController::class, 'index'])
    ->name('cursos.index');

Route::get('/curso/{materia}', [App\Http\Controllers\ContenidoController::class, 'mostrarMateria'])
    ->name('cursos.materia');

Route::get('/curso/{materia}/{tema}', [App\Http\Controllers\ContenidoController::class, 'mostrarTema'])
    ->name('cursos.tema');

// API Routes para evaluación con IA
Route::prefix('api')->group(function () {
    Route::post('/evaluar-pregunta', [EvaluacionController::class, 'evaluarPregunta'])
        ->name('api.evaluar.pregunta');
    
    Route::post('/evaluar-prueba', [EvaluacionController::class, 'evaluarPrueba'])
        ->name('api.evaluar.prueba');
});