<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Estudiante - EduSystem</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Feedback Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/feedback-styles.css')); ?>">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: 260px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            color: white;
            overflow-y: auto;
            z-index: 1000;
            transition: all 0.3s;
        }
        
        .sidebar-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.2);
        }
        
        .sidebar-header i {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .sidebar-header h4 {
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .sidebar-header p {
            font-size: 0.85rem;
            opacity: 0.8;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 0;
        }
        
        .sidebar-menu li {
            margin-bottom: 5px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            color: white;
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: rgba(255,255,255,0.2);
            transform: translateX(5px);
        }
        
        .sidebar-menu i {
            margin-right: 10px;
            width: 20px;
        }
        
        .logout-btn {
            margin-top: 20px;
            padding: 12px;
            background: rgba(255,255,255,0.1);
            border: none;
            color: white;
            border-radius: 10px;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.2);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 30px;
            min-height: 100vh;
        }
        
        .top-bar {
            background: white;
            padding: 20px 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .top-bar h2 {
            margin: 0;
            color: #333;
            font-weight: 700;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }
        
        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .stat-info h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 5px;
            color: #333;
        }
        
        .stat-info p {
            color: #999;
            margin: 0;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
        }
        
        .stat-icon.blue {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .stat-icon.green {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .stat-icon.orange {
            background: rgba(255, 193, 7, 0.1);
            color: #ffc107;
        }
        
        /* Content Sections */
        .content-section {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .section-header h3 {
            margin: 0;
            color: #333;
            font-weight: 600;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 10px 20px;
            border-radius: 10px;
            color: white;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }
        
        .course-card {
            background: white;
            border: 2px solid #f0f0f0;
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s;
        }
        
        .course-card:hover {
            border-color: #667eea;
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.2);
        }
        
        .course-card h4 {
            color: #333;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        .course-card p {
            color: #666;
            font-size: 0.9rem;
            margin-bottom: 15px;
        }
        
        .course-meta {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            font-size: 0.85rem;
            color: #999;
        }
        
        .course-meta span {
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .card-actions {
            display: flex;
            gap: 10px;
        }
        
        .card-actions button {
            flex: 1;
            padding: 8px;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-take-test {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .btn-take-test:hover {
            background: #28a745;
            color: white;
        }
        
        .btn-view-results {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .btn-view-results:hover {
            background: #667eea;
            color: white;
        }
        
        /* Test Taking Interface */
        .test-container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .question-card {
            background: white;
            border: 2px solid #f0f0f0;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 20px;
        }
        
        .question-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .question-number {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 600;
        }
        
        .question-text {
            font-size: 1.2rem;
            color: #333;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .option-item {
            background: #f8f9fa;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 15px;
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        
        .option-item:hover {
            background: rgba(102, 126, 234, 0.1);
            border-color: #667eea;
        }
        
        .option-item input[type="radio"] {
            margin-right: 10px;
        }
        
        .option-item label {
            cursor: pointer;
            margin: 0;
            width: 100%;
        }
        
        .test-navigation {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }
        
        /* Results */
        .result-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            margin-bottom: 20px;
        }
        
        .result-score {
            font-size: 4rem;
            font-weight: 700;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 10px;
        }
        
        .result-message {
            font-size: 1.5rem;
            color: #333;
            margin-bottom: 20px;
        }
        
        .result-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        
        .result-detail-item {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
        }
        
        .result-detail-item h4 {
            font-size: 2rem;
            margin-bottom: 5px;
            color: #333;
        }
        
        .result-detail-item p {
            color: #666;
            margin: 0;
            font-size: 0.9rem;
        }
        
        /* Table */
        .custom-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
        }
        
        .custom-table thead th {
            background: #f8f9fa;
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #666;
            border: none;
        }
        
        .custom-table tbody tr {
            background: white;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .custom-table tbody tr:hover {
            transform: translateX(5px);
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        
        .custom-table tbody td {
            padding: 15px;
            border: none;
        }
        
        .custom-table tbody tr td:first-child {
            border-radius: 10px 0 0 10px;
        }
        
        .custom-table tbody tr td:last-child {
            border-radius: 0 10px 10px 0;
        }
        
        .score-badge {
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .score-excellent {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }
        
        .score-good {
            background: rgba(102, 126, 234, 0.1);
            color: #667eea;
        }
        
        .score-average {
            background: rgba(255, 193, 7, 0.1);
            color: #ffc107;
        }
        
        .score-poor {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                width: 70px;
            }
            
            .sidebar-header h4,
            .sidebar-header p,
            .sidebar-menu span {
                display: none;
            }
            
            .main-content {
                margin-left: 70px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .cards-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-user-graduate"></i>
            <h4>EduSystem</h4>
            <p id="userRole">Estudiante</p>
        </div>
        
        <ul class="sidebar-menu">
            <li><a href="#" class="active" onclick="showSection('dashboard')"><i class="fas fa-home"></i> <span>Dashboard</span></a></li>
            <li><a href="#" onclick="showSection('courses')"><i class="fas fa-book"></i> <span>Mis Cursos</span></a></li>
            <li><a href="#" onclick="showSection('results')"><i class="fas fa-chart-line"></i> <span>Mis Resultados</span></a></li>
            <li><a href="#" onclick="showSection('profile')"><i class="fas fa-user"></i> <span>Mi Perfil</span></a></li>
        </ul>
        
        <button class="logout-btn" onclick="logout()">
            <i class="fas fa-sign-out-alt"></i> <span>Cerrar Sesión</span>
        </button>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <div class="top-bar">
            <h2 id="pageTitle">Dashboard</h2>
            <div class="user-info">
                <div class="user-avatar" id="userAvatar">E</div>
                <div>
                    <strong id="userName">Estudiante</strong>
                    <p style="margin: 0; font-size: 0.85rem; color: #999;">Estudiante</p>
                </div>
            </div>
        </div>

        <!-- Dashboard Section -->
        <div id="dashboardSection">
            <!-- Stats Cards -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="availableCourses">0</h3>
                        <p>Cursos Disponibles</p>
                    </div>
                    <div class="stat-icon blue">
                        <i class="fas fa-book"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="completedTests">0</h3>
                        <p>Pruebas Completadas</p>
                    </div>
                    <div class="stat-icon green">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-info">
                        <h3 id="averageScore">0%</h3>
                        <p>Promedio General</p>
                    </div>
                    <div class="stat-icon orange">
                        <i class="fas fa-star"></i>
                    </div>
                </div>
            </div>

            <!-- Available Tests -->
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-clipboard-list"></i> Pruebas Disponibles</h3>
                </div>
                <div class="cards-grid" id="availableTests">
                    <p style="text-align: center; color: #999; padding: 40px;">
                        No hay pruebas disponibles en este momento
                    </p>
                </div>
            </div>
        </div>

        <!-- Courses Section -->
        <div id="coursesSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-book"></i> Mis Cursos</h3>
                </div>
                <div class="cards-grid" id="coursesGrid">
                </div>
            </div>
        </div>

        <!-- Results Section -->
        <div id="resultsSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-chart-line"></i> Historial de Resultados</h3>
                </div>
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>Prueba</th>
                            <th>Curso</th>
                            <th>Fecha</th>
                            <th>Puntuación</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody id="resultsTableBody">
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Profile Section -->
        <div id="profileSection" style="display: none;">
            <div class="content-section">
                <div class="section-header">
                    <h3><i class="fas fa-user"></i> Mi Perfil</h3>
                </div>
                
                <form id="profileForm">
                    <div class="mb-3">
                        <label class="form-label">Nombre Completo</label>
                        <input type="text" class="form-control" id="profileName" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" id="profileEmail" required>
                    </div>
                    <button type="submit" class="btn-primary-custom">
                        <i class="fas fa-save"></i> Guardar Cambios
                    </button>
                </form>
            </div>
        </div>

        <!-- Test Taking Section -->
        <div id="testTakingSection" style="display: none;">
            <div class="test-container">
                <div class="content-section">
                    <div class="section-header">
                        <h3 id="testTitle"></h3>
                        <span id="testTimer"></span>
                    </div>
                    <div id="questionsContainer"></div>
                    <div class="test-navigation">
                        <button class="btn btn-secondary" onclick="cancelTest()">
                            <i class="fas fa-times"></i> Cancelar
                        </button>
                        <button class="btn-primary-custom" onclick="submitTest()">
                            <i class="fas fa-check"></i> Enviar Respuestas
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Test Result Section -->
        <div id="testResultSection" style="display: none;">
            <div class="test-container">
                <div class="result-card">
                    <div class="result-score" id="resultScore">0%</div>
                    <div class="result-message" id="resultMessage">¡Buen trabajo!</div>
                    <div class="result-details">
                        <div class="result-detail-item">
                            <h4 id="correctAnswers">0</h4>
                            <p>Correctas</p>
                        </div>
                        <div class="result-detail-item">
                            <h4 id="incorrectAnswers">0</h4>
                            <p>Incorrectas</p>
                        </div>
                        <div class="result-detail-item">
                            <h4 id="totalQuestions">0</h4>
                            <p>Total</p>
                        </div>
                    </div>
                    <button class="btn-primary-custom mt-4" onclick="backToDashboard()">
                        <i class="fas fa-home"></i> Volver al Dashboard
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auth JS -->
    <script src="../assets/js/auth.js"></script>
     <!-- Data -->
    <script src="../assets/js/data.js"></script>
    <!-- Evaluación con IA -->
    <script src="<?php echo e(asset('assets/js/evaluacion-ia.js')); ?>"></script>
    
    <script>
        // Check authentication
        const currentUser = requireAuth(['estudiante']);
        
        if (currentUser) {
            document.getElementById('userName').textContent = currentUser.name;
            document.getElementById('userAvatar').textContent = currentUser.name.charAt(0).toUpperCase();
            document.getElementById('profileName').value = currentUser.name;
            document.getElementById('profileEmail').value = currentUser.email;
        }
        
        let currentTestId = null;
        let userAnswers = {};
        
        // Load initial data
        loadDashboardStats();
        loadAvailableTests();
        loadMyCourses();
        loadMyResults();
        
        // Show section
        function showSection(section) {
            document.getElementById('dashboardSection').style.display = 'none';
            document.getElementById('coursesSection').style.display = 'none';
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('profileSection').style.display = 'none';
            document.getElementById('testTakingSection').style.display = 'none';
            document.getElementById('testResultSection').style.display = 'none';
            
            if (section === 'dashboard') {
                document.getElementById('dashboardSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Dashboard';
                loadAvailableTests();
            } else if (section === 'courses') {
                document.getElementById('coursesSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Mis Cursos';
                loadMyCourses();
            } else if (section === 'results') {
                document.getElementById('resultsSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Mis Resultados';
                loadMyResults();
            } else if (section === 'profile') {
                document.getElementById('profileSection').style.display = 'block';
                document.getElementById('pageTitle').textContent = 'Mi Perfil';
            }
            
            document.querySelectorAll('.sidebar-menu a').forEach(a => a.classList.remove('active'));
            if (event && event.target) {
                event.target.closest('a').classList.add('active');
            }
        }
        
        // Load dashboard stats
        function loadDashboardStats() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const results = JSON.parse(localStorage.getItem('results')) || [];
            const myResults = results.filter(r => r.userId === currentUser.id);
            
            document.getElementById('availableCourses').textContent = courses.length;
            document.getElementById('completedTests').textContent = myResults.length;
            
            if (myResults.length > 0) {
                const avg = myResults.reduce((sum, r) => sum + r.score, 0) / myResults.length;
                document.getElementById('averageScore').textContent = Math.round(avg) + '%';
            } else {
                document.getElementById('averageScore').textContent = '0%';
            }
        }
        
        // Load available tests
        function loadAvailableTests() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const results = JSON.parse(localStorage.getItem('results')) || [];
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            
            const container = document.getElementById('availableTests');
            
            if (tests.length === 0) {
                container.innerHTML = '<p style="text-align: center; color: #999; padding: 40px;">No hay pruebas disponibles en este momento</p>';
                return;
            }
            
            container.innerHTML = tests.map(test => {
                const course = courses.find(c => c.id === test.courseId);
                const testQuestions = questions.filter(q => q.testId === test.id);
                const completed = results.some(r => r.testId === test.id && r.userId === currentUser.id);
                
                if (testQuestions.length === 0) return '';
                
                return `
                    <div class="course-card">
                        <h4>${test.title}</h4>
                        <p><strong>Curso:</strong> ${course ? course.name : 'N/A'}</p>
                        <div class="course-meta">
                            <span><i class="fas fa-question-circle"></i> ${testQuestions.length} preguntas</span>
                            ${test.deadline ? `<span><i class="fas fa-calendar"></i> ${new Date(test.deadline).toLocaleDateString()}</span>` : ''}
                        </div>
                        <div class="card-actions">
                            ${completed ? 
                                `<button class="btn-view-results" onclick="viewTestResult(${test.id})">
                                    <i class="fas fa-eye"></i> Ver Resultado
                                </button>` :
                                `<button class="btn-take-test" onclick="startTest(${test.id})">
                                    <i class="fas fa-play"></i> Tomar Prueba
                                </button>`
                            }
                        </div>
                    </div>
                `;
            }).join('');
        }
        
        // Load my courses
        function loadMyCourses() {
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const users = JSON.parse(localStorage.getItem('users')) || [];
            const grid = document.getElementById('coursesGrid');
            
            if (courses.length === 0) {
                grid.innerHTML = '<p style="text-align: center; color: #999; padding: 40px;">No hay cursos disponibles</p>';
                return;
            }
            
            grid.innerHTML = courses.map(course => {
                const courseTests = tests.filter(t => t.courseId === course.id);
                const teacher = users.find(u => u.id === course.teacherId);
                return `
                    <div class="course-card">
                        <h4>${course.name}</h4>
                        <p>${course.description}</p>
                        <div class="course-meta">
                            <span><i class="fas fa-user"></i> ${teacher ? teacher.name : 'Sin profesor'}</span>
                            <span><i class="fas fa-clipboard-list"></i> ${courseTests.length} pruebas</span>
                        </div>
                    </div>
                `;
            }).join('');
        }
        
        // Load my results
        function loadMyResults() {
            const results = JSON.parse(localStorage.getItem('results')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            const myResults = results.filter(r => r.userId === currentUser.id);
            const tbody = document.getElementById('resultsTableBody');
            
            if (myResults.length === 0) {
                tbody.innerHTML = '<tr><td colspan="5" style="text-align: center; color: #999;">No has completado ninguna prueba aún</td></tr>';
                return;
            }
            
            tbody.innerHTML = myResults.map(result => {
                const test = tests.find(t => t.id === result.testId);
                const course = test ? courses.find(c => c.id === test.courseId) : null;
                
                let scoreClass = 'score-poor';
                if (result.score >= 90) scoreClass = 'score-excellent';
                else if (result.score >= 70) scoreClass = 'score-good';
                else if (result.score >= 50) scoreClass = 'score-average';
                
                return `
                    <tr>
                        <td>${test ? test.title : 'N/A'}</td>
                        <td>${course ? course.name : 'N/A'}</td>
                        <td>${new Date(result.completedAt).toLocaleDateString()}</td>
                        <td><span class="score-badge ${scoreClass}">${result.score}%</span></td>
                        <td>
                            <small style="color: #999;">
                                ${result.correctAnswers} de ${result.totalQuestions} correctas
                            </small>
                        </td>
                    </tr>
                `;
            }).join('');
        }
        
        // Start test
        function startTest(testId) {
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const test = tests.find(t => t.id === testId);
            const testQuestions = questions.filter(q => q.testId === testId);
            
            if (!test || testQuestions.length === 0) {
                alert('Esta prueba no tiene preguntas disponibles');
                return;
            }
            
            currentTestId = testId;
            userAnswers = {};
            
            // Hide all sections
            document.getElementById('dashboardSection').style.display = 'none';
            document.getElementById('coursesSection').style.display = 'none';
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('profileSection').style.display = 'none';
            document.getElementById('testResultSection').style.display = 'none';
            
            // Show test taking section
            document.getElementById('testTakingSection').style.display = 'block';
            document.getElementById('pageTitle').textContent = 'Tomando Prueba';
            document.getElementById('testTitle').textContent = test.title;
            
            // Render questions
            const container = document.getElementById('questionsContainer');
            container.innerHTML = testQuestions.map((q, index) => `
                <div class="question-card">
                    <div class="question-header">
                        <span class="question-number">Pregunta ${index + 1} de ${testQuestions.length}</span>
                    </div>
                    <div class="question-text">${q.question}</div>
                    <div class="options-container">
                        ${q.options.map((opt, optIndex) => `
                            <div class="option-item">
                                <input type="radio" 
                                       name="question${q.id}" 
                                       id="q${q.id}_opt${optIndex}" 
                                       value="${optIndex}"
                                       onchange="saveAnswer(${q.id}, ${optIndex})">
                                <label for="q${q.id}_opt${optIndex}">${opt.text}</label>
                            </div>
                        `).join('')}
                    </div>
                </div>
            `).join('');
        }
        
        // Save answer
        function saveAnswer(questionId, optionIndex) {
            userAnswers[questionId] = optionIndex;
        }
        
        // Cancel test
        function cancelTest() {
            if (confirm('¿Estás seguro de cancelar esta prueba? Perderás todo el progreso.')) {
                currentTestId = null;
                userAnswers = {};
                showSection('dashboard');
            }
        }
        
        // Submit test
        function submitTest() {
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            const testQuestions = questions.filter(q => q.testId === currentTestId);
            
            // Check if all questions are answered
            if (Object.keys(userAnswers).length !== testQuestions.length) {
                if (!confirm('No has respondido todas las preguntas. ¿Deseas enviar de todos modos?')) {
                    return;
                }
            }
            
            // Calculate score
            let correctAnswers = 0;
            testQuestions.forEach(q => {
                const userAnswer = userAnswers[q.id];
                if (userAnswer !== undefined) {
                    const correctOption = q.options.findIndex(opt => opt.isCorrect);
                    if (userAnswer === correctOption) {
                        correctAnswers++;
                    }
                }
            });
            
            const score = Math.round((correctAnswers / testQuestions.length) * 100);
            
            // Save result
            const results = JSON.parse(localStorage.getItem('results')) || [];
            const newResult = {
                id: results.length + 1,
                userId: currentUser.id,
                testId: currentTestId,
                score: score,
                correctAnswers: correctAnswers,
                totalQuestions: testQuestions.length,
                completedAt: new Date().toISOString()
            };
            
            results.push(newResult);
            localStorage.setItem('results', JSON.stringify(results));
            
            // Show result
            showTestResult(score, correctAnswers, testQuestions.length);
        }
        
        // Show test result
        function showTestResult(score, correct, total) {
            document.getElementById('testTakingSection').style.display = 'none';
            document.getElementById('testResultSection').style.display = 'block';
            document.getElementById('pageTitle').textContent = 'Resultado de la Prueba';
            
            document.getElementById('resultScore').textContent = score + '%';
            document.getElementById('correctAnswers').textContent = correct;
            document.getElementById('incorrectAnswers').textContent = total - correct;
            document.getElementById('totalQuestions').textContent = total;
            
            let message = '';
            if (score >= 90) message = '¡Excelente trabajo!';
            else if (score >= 70) message = '¡Muy bien!';
            else if (score >= 50) message = '¡Buen esfuerzo!';
            else message = 'Sigue practicando';
            
            document.getElementById('resultMessage').textContent = message;
            
            loadDashboardStats();
        }
        
        // View test result
        function viewTestResult(testId) {
            const results = JSON.parse(localStorage.getItem('results')) || [];
            const result = results.find(r => r.testId === testId && r.userId === currentUser.id);
            
            if (result) {
                showTestResult(result.score, result.correctAnswers, result.totalQuestions);
            }
        }
        
        // Back to dashboard
        function backToDashboard() {
            currentTestId = null;
            userAnswers = {};
            showSection('dashboard');
        }
        
        // Update profile
        document.getElementById('profileForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const name = document.getElementById('profileName').value;
            const email = document.getElementById('profileEmail').value;
            
            const result = updateProfile(name, email);
            alert(result.message);
            
            if (result.success) {
                document.getElementById('userName').textContent = name;
                document.getElementById('userAvatar').textContent = name.charAt(0).toUpperCase();
            }
        });

        // Agregar al final del script existente en estudiantes.blade.php

        // Modificar la función submitTest() existente para integrar IA
        async function submitTest() {
            const questions = JSON.parse(localStorage.getItem('questions')) || [];
            const tests = JSON.parse(localStorage.getItem('tests')) || [];
            const courses = JSON.parse(localStorage.getItem('courses')) || [];
            
            const testQuestions = questions.filter(q => q.testId === currentTestId);
            const test = tests.find(t => t.id === currentTestId);
            const course = courses.find(c => c.id === test.courseId);
            
            // Verificar si todas las preguntas están respondidas
            if (Object.keys(userAnswers).length !== testQuestions.length) {
                if (!confirm('No has respondido todas las preguntas. ¿Deseas enviar de todos modos?')) {
                    return;
                }
            }
            
            // Preparar respuestas para evaluación con IA
            const respuestasParaIA = testQuestions.map(q => {
                const userAnswer = userAnswers[q.id];
                const correctOptionIndex = q.options.findIndex(opt => opt.isCorrect);
                const isCorrect = userAnswer === correctOptionIndex;
                
                return {
                    pregunta: q.question,
                    respuesta_correcta: q.options[correctOptionIndex]?.text || 'N/A',
                    respuesta_estudiante: userAnswer !== undefined ? q.options[userAnswer]?.text : 'Sin responder',
                    correcta: isCorrect,
                    pregunta_id: q.id
                };
            });
            
            // Calcular estadísticas básicas
            const correctAnswers = respuestasParaIA.filter(r => r.correcta).length;
            const score = Math.round((correctAnswers / testQuestions.length) * 100);
            
            // Evaluar con IA
            try {
                const resultado = await window.evaluacionIA.evaluarPrueba(
                    currentTestId,
                    respuestasParaIA,
                    course?.name || 'General',
                    test?.title || 'Evaluación'
                );
                
                // Guardar resultado en localStorage
                const results = JSON.parse(localStorage.getItem('results')) || [];
                const newResult = {
                    id: results.length + 1,
                    userId: currentUser.id,
                    testId: currentTestId,
                    score: score,
                    correctAnswers: correctAnswers,
                    totalQuestions: testQuestions.length,
                    completedAt: new Date().toISOString(),
                    retroalimentacion: resultado // Guardar retroalimentación de IA
                };
                
                results.push(newResult);
                localStorage.setItem('results', JSON.stringify(results));
                
                // Mostrar resultados con retroalimentación de IA
                window.evaluacionIA.mostrarResultadosConIA(resultado);
                
                // Actualizar estadísticas
                loadDashboardStats();
                
            } catch (error) {
                console.error('Error al evaluar con IA:', error);
                // Fallback a evaluación básica sin IA
                showTestResult(score, correctAnswers, testQuestions.length);
            }
        }

        // Función auxiliar para ver resultados previos con IA
        function viewTestResult(testId) {
            const results = JSON.parse(localStorage.getItem('results')) || [];
            const result = results.find(r => r.testId === testId && r.userId === currentUser.id);
            
            if (result && result.retroalimentacion) {
                // Si tiene retroalimentación de IA guardada
                window.evaluacionIA.mostrarResultadosConIA(result.retroalimentacion);
            } else if (result) {
                // Fallback a visualización básica
                showTestResult(result.score, result.correctAnswers, result.totalQuestions);
            }
        }
    </script>

</body>
</html><?php /**PATH C:\xampp\htdocs\edu_demo\resources\views/dashboard/estudiantes.blade.php ENDPATH**/ ?>