<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cursos - EduSystem</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
        }
        
        .navbar-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .navbar-custom .navbar-brand {
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
        }
        
        .navbar-custom .nav-link {
            color: rgba(255,255,255,0.9);
            margin: 0 10px;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .hero-section h1 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .hero-section p {
            font-size: 1.3rem;
            opacity: 0.9;
        }
        
        .courses-container {
            max-width: 1200px;
            margin: -50px auto 50px;
            padding: 0 15px;
        }
        
        .courses-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 30px;
            margin-top: 30px;
        }
        
        .course-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            transition: all 0.3s;
            text-decoration: none;
            color: inherit;
        }
        
        .course-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
        }
        
        .course-icon {
            width: 70px;
            height: 70px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-bottom: 20px;
        }
        
        .course-card.matematicas .course-icon {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .course-card.lenguaje .course-icon {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
        }
        
        .course-card.ciencias .course-icon {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
        }
        
        .course-card h3 {
            color: #333;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .course-card p {
            color: #666;
            margin-bottom: 20px;
        }
        
        .topics-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .topics-list li {
            padding: 8px 0;
            color: #555;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .topics-list li i {
            color: #667eea;
        }
        
        .btn-view-course {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px 24px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 600;
            margin-top: 15px;
            transition: all 0.3s;
        }
        
        .btn-view-course:hover {
            transform: translateX(5px);
            color: white;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('cursos.index')); ?>">
                <i class="fas fa-graduation-cap"></i> EduSystem
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('dashboard.estudiantes')); ?>">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <h1><i class="fas fa-book-open"></i> Centro de Aprendizaje</h1>
            <p>Explora nuestros cursos y mejora tus conocimientos</p>
        </div>
    </section>

    <!-- Courses -->
    <div class="courses-container">
        <div class="courses-grid">
            <?php $__currentLoopData = $materias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $materia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('cursos.materia', $key)); ?>" class="course-card <?php echo e($key); ?>">
                    <div class="course-icon">
                        <?php if($key === 'matematicas'): ?>
                            <i class="fas fa-calculator"></i>
                        <?php elseif($key === 'lenguaje'): ?>
                            <i class="fas fa-pen-fancy"></i>
                        <?php elseif($key === 'ciencias'): ?>
                            <i class="fas fa-flask"></i>
                        <?php endif; ?>
                    </div>
                    <h3><?php echo e($materia['titulo']); ?></h3>
                    <p><?php echo e($materia['descripcion']); ?></p>
                    
                    <ul class="topics-list">
                        <?php $__currentLoopData = array_slice($materia['temas'], 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $temaKey => $tema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <i class="fas fa-check-circle"></i>
                                <?php echo e($tema['titulo']); ?>

                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(count($materia['temas']) > 3): ?>
                            <li>
                                <i class="fas fa-ellipsis-h"></i>
                                Y más...
                            </li>
                        <?php endif; ?>
                    </ul>
                    
                    <span class="btn-view-course">
                        Ver curso <i class="fas fa-arrow-right"></i>
                    </span>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\edu_demo\resources\views/contenidos/index.blade.php ENDPATH**/ ?>