<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($temaDatos['titulo']); ?> - EduSystem</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f5f7fa;
            line-height: 1.6;
        }
        
        /* Navbar */
        .navbar-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .navbar-custom .navbar-brand {
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
        }
        
        .navbar-custom .nav-link {
            color: rgba(255,255,255,0.9);
            margin: 0 10px;
            transition: all 0.3s;
        }
        
        .navbar-custom .nav-link:hover {
            color: white;
        }
        
        /* Breadcrumb */
        .breadcrumb-custom {
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            margin: 20px 0;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }
        
        .breadcrumb-custom a {
            color: #667eea;
            text-decoration: none;
        }
        
        .breadcrumb-custom a:hover {
            text-decoration: underline;
        }
        
        /* Content Container */
        .content-wrapper {
            max-width: 1000px;
            margin: 0 auto;
            padding: 30px 15px;
        }
        
        .page-header {
            background: white;
            padding: 40px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .page-header h1 {
            color: #333;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .page-header .subtitle {
            color: #666;
            font-size: 1.1rem;
        }
        
        /* Content Cards */
        .content-card {
            background: white;
            padding: 35px;
            border-radius: 15px;
            margin-bottom: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            border-left: 4px solid #667eea;
        }
        
        .content-card.introduccion {
            border-left-color: #667eea;
        }
        
        .content-card.concepto {
            border-left-color: #28a745;
        }
        
        .content-card.ejercicio {
            border-left-color: #ffc107;
        }
        
        .content-card h3 {
            color: #333;
            font-weight: 600;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .content-card h3 i {
            font-size: 1.3rem;
        }
        
        .content-card p {
            color: #555;
            font-size: 1.05rem;
            margin-bottom: 15px;
        }
        
        .ejemplo-box {
            background: #f8f9fa;
            border-left: 3px solid #667eea;
            padding: 20px;
            margin-top: 15px;
            border-radius: 5px;
        }
        
        .ejemplo-box strong {
            color: #667eea;
            display: block;
            margin-bottom: 10px;
        }
        
        .ejercicio-list {
            list-style: none;
            padding: 0;
        }
        
        .ejercicio-list li {
            background: #f8f9fa;
            padding: 15px 20px;
            margin-bottom: 10px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .ejercicio-list li::before {
            content: "📝";
            font-size: 1.5rem;
        }
        
        /* Resources Section */
        .resources-section {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
            padding: 30px;
            border-radius: 15px;
            margin-top: 30px;
        }
        
        .resources-section h3 {
            color: #333;
            font-weight: 600;
            margin-bottom: 20px;
        }
        
        .resource-item {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 15px;
            text-decoration: none;
            color: inherit;
            transition: all 0.3s;
        }
        
        .resource-item:hover {
            transform: translateX(5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .resource-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
        }
        
        /* Navigation Buttons */
        .nav-buttons {
            display: flex;
            gap: 15px;
            margin-top: 40px;
        }
        
        .btn-custom {
            flex: 1;
            padding: 15px 30px;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-primary-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
        
        .btn-secondary-custom {
            background: white;
            color: #667eea;
            border: 2px solid #667eea;
        }
        
        .btn-secondary-custom:hover {
            background: #667eea;
            color: white;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('cursos.index')); ?>">
                <i class="fas fa-graduation-cap"></i> EduSystem
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('cursos.index')); ?>">
                            <i class="fas fa-book"></i> Cursos
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('dashboard.estudiantes')); ?>">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Content -->
    <div class="content-wrapper">
        <!-- Breadcrumb -->
        <div class="breadcrumb-custom">
            <a href="<?php echo e(route('cursos.index')); ?>">Cursos</a> /
            <a href="<?php echo e(route('cursos.materia', $materia)); ?>"><?php echo e($materiaDatos['titulo']); ?></a> /
            <strong><?php echo e($temaDatos['titulo']); ?></strong>
        </div>

        <!-- Page Header -->
        <div class="page-header">
            <h1><?php echo e($temaDatos['titulo']); ?></h1>
            <p class="subtitle"><?php echo e($temaDatos['descripcion']); ?></p>
        </div>

        <!-- Content Sections -->
        <?php $__currentLoopData = $temaDatos['contenido']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="content-card <?php echo e($seccion['tipo']); ?>">
                <h3>
                    <?php if($seccion['tipo'] === 'introduccion'): ?>
                        <i class="fas fa-book-open"></i>
                    <?php elseif($seccion['tipo'] === 'concepto'): ?>
                        <i class="fas fa-lightbulb"></i>
                    <?php elseif($seccion['tipo'] === 'ejercicio'): ?>
                        <i class="fas fa-pencil-alt"></i>
                    <?php endif; ?>
                    <?php echo e($seccion['titulo']); ?>

                </h3>
                
                <?php if(isset($seccion['texto'])): ?>
                    <p><?php echo $seccion['texto']; ?></p>
                <?php endif; ?>
                
                <?php if(isset($seccion['ejemplo'])): ?>
                    <div class="ejemplo-box">
                        <strong>Ejemplo:</strong>
                        <p><?php echo $seccion['ejemplo']; ?></p>
                    </div>
                <?php endif; ?>
                
                <?php if(isset($seccion['problemas'])): ?>
                    <ul class="ejercicio-list">
                        <?php $__currentLoopData = $seccion['problemas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $problema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($problema); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Resources -->
        <?php if(isset($temaDatos['recursos']) && count($temaDatos['recursos']) > 0): ?>
            <div class="resources-section">
                <h3><i class="fas fa-folder-open"></i> Recursos Adicionales</h3>
                
                <?php $__currentLoopData = $temaDatos['recursos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recurso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($recurso['url']); ?>" class="resource-item">
                        <div class="resource-icon">
                            <?php if($recurso['tipo'] === 'video'): ?>
                                <i class="fas fa-play-circle"></i>
                            <?php elseif($recurso['tipo'] === 'pdf'): ?>
                                <i class="fas fa-file-pdf"></i>
                            <?php else: ?>
                                <i class="fas fa-file"></i>
                            <?php endif; ?>
                        </div>
                        <div>
                            <strong><?php echo e($recurso['titulo']); ?></strong>
                            <small class="d-block text-muted"><?php echo e(ucfirst($recurso['tipo'])); ?></small>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <!-- Navigation Buttons -->
        <div class="nav-buttons">
            <a href="<?php echo e(route('cursos.materia', $materia)); ?>" class="btn-secondary-custom">
                <i class="fas fa-arrow-left"></i> Volver a <?php echo e($materiaDatos['titulo']); ?>

            </a>
            <a href="<?php echo e(route('dashboard.estudiantes')); ?>" class="btn-primary-custom">
                <i class="fas fa-clipboard-check"></i> Tomar Prueba
            </a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH C:\xampp\htdocs\edu_demo\resources\views/contenidos/tema.blade.php ENDPATH**/ ?>