<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - EduSystem</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
            max-width: 450px;
            width: 100%;
            animation: fadeInUp 0.6s ease;
        }
        
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        
        .login-header i {
            font-size: 3rem;
            margin-bottom: 15px;
        }
        
        .login-header h2 {
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .login-header p {
            opacity: 0.9;
            font-size: 0.95rem;
        }
        
        .login-body {
            padding: 40px 30px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
        }
        
        .form-control {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 12px 15px;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .input-group-text {
            background: #f8f9fa;
            border: 2px solid #e0e0e0;
            border-right: none;
            border-radius: 10px 0 0 10px;
        }
        
        .input-group .form-control {
            border-left: none;
            border-radius: 0 10px 10px 0;
        }
        
        .btn-login {
            width: 100%;
            padding: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 10px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.4);
        }
        
        .divider {
            text-align: center;
            margin: 25px 0;
            position: relative;
        }
        
        .divider::before {
            content: "";
            position: absolute;
            left: 0;
            top: 50%;
            width: 100%;
            height: 1px;
            background: #e0e0e0;
        }
        
        .divider span {
            background: white;
            padding: 0 15px;
            position: relative;
            color: #999;
            font-size: 0.9rem;
        }
        
        .demo-users {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .demo-users h6 {
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
            font-size: 0.9rem;
        }
        
        .demo-user {
            background: white;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 8px;
            cursor: pointer;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        
        .demo-user:hover {
            border-color: #667eea;
            transform: translateX(5px);
        }
        
        .demo-user:last-child {
            margin-bottom: 0;
        }
        
        .demo-user strong {
            color: #667eea;
            display: block;
            font-size: 0.85rem;
        }
        
        .demo-user small {
            color: #666;
            font-size: 0.75rem;
        }
        
        .back-home {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-home a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .back-home a:hover {
            color: #764ba2;
        }
        
        .alert {
            border-radius: 10px;
            border: none;
            animation: slideDown 0.3s ease;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @media (max-width: 576px) {
            .login-container {
                margin: 10px;
            }
            
            .login-header {
                padding: 30px 20px;
            }
            
            .login-body {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    
    <div class="login-container">
        <div class="login-header">
            <i class="fas fa-graduation-cap"></i>
            <h2>EduSystem</h2>
            <p>Iniciar Sesión</p>
        </div>
        
        <div class="login-body">
            <!-- Alert Messages -->
            <div id="alertContainer"></div>
            
            <!-- Demo Users Info -->
            <div class="demo-users">
                <h6><i class="fas fa-info-circle"></i> Usuarios Demo</h6>
                <div class="demo-user" onclick="fillLogin('admin@edu.com', 'admin123')">
                    <strong><i class="fas fa-user-shield"></i> Administrador</strong>
                    <small>admin@edu.com / admin123</small>
                </div>
                <div class="demo-user" onclick="fillLogin('prof@edu.com', 'prof123')">
                    <strong><i class="fas fa-chalkboard-teacher"></i> Profesor</strong>
                    <small>prof@edu.com / prof123</small>
                </div>
                <div class="demo-user" onclick="fillLogin('est@edu.com', 'est123')">
                    <strong><i class="fas fa-user-graduate"></i> Estudiante</strong>
                    <small>est@edu.com / est123</small>
                </div>
            </div>
            
            <!-- Login Form -->
            <form id="loginForm">
                <div class="form-group">
                    <label class="form-label">Correo Electrónico</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-envelope"></i>
                        </span>
                        <input type="email" class="form-control" id="email" placeholder="ejemplo@correo.com" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Contraseña</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input type="password" class="form-control" id="password" placeholder="••••••••" required>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-login">
                    <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                </button>
            </form>
            
            <div class="divider">
                <span>o</span>
            </div>
            
            <div class="text-center">
                <p class="mb-0">¿No tienes una cuenta? <a href="<?php echo e(route('register')); ?>" style="color: #667eea; font-weight: 600;">Regístrate</a></p>
            </div>
            
            <div class="back-home">
                <a href="<?php echo e(route('home')); ?>"><i class="fas fa-arrow-left"></i> Volver al inicio</a>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auth JS -->
    <script src="assets/js/auth.js"></script>
    <script src="../assets/js/data.js"></script>

    <script>
        // Fill login fields (for demo users)
        function fillLogin(email, password) {
            document.getElementById('email').value = email;
            document.getElementById('password').value = password;
        }
        
        // Handle login form
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;
            
            const result = login(email, password);
            
            if (result.success) {
                showAlert('success', result.message);
                setTimeout(() => {
                    window.location.href = result.redirect;
                }, 1000);
            } else {
                showAlert('danger', result.message);
            }
        });
        
        // Show alert message
        function showAlert(type, message) {
            const alertContainer = document.getElementById('alertContainer');
            alertContainer.innerHTML = `
                <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            `;
        }
        
        // Check if already logged in
        if (isLoggedIn()) {
            const user = getCurrentUser();

            let redirectUrl = '';
            switch(user.role) {
                case 'admin':
                    redirectUrl = "<?php echo e(route('dashboard.admin')); ?>";
                    break;
                case 'profesor':
                    redirectUrl = "<?php echo e(route('dashboard.profesor')); ?>";
                    break;
                case 'estudiante':
                    redirectUrl = "<?php echo e(route('dashboard.estudiantes')); ?>";
                    break;
            }
            window.location.href = redirectUrl;
        }

    </script>
    
</body>
</html><?php /**PATH C:\xampp\htdocs\edu_demo\resources\views/login.blade.php ENDPATH**/ ?>