(function () {
  "use strict";

  /**
   * Apply .scrolled class to the body as the page is scrolled down
   */
  function toggleScrolled() {
    const selectBody = document.querySelector("body");
    const selectHeader = document.querySelector("#header");
    if (
      !selectHeader.classList.contains("scroll-up-sticky") &&
      !selectHeader.classList.contains("sticky-top") &&
      !selectHeader.classList.contains("fixed-top")
    )
      return;
    window.scrollY > 100
      ? selectBody.classList.add("scrolled")
      : selectBody.classList.remove("scrolled");
  }

  document.addEventListener("scroll", toggleScrolled);
  window.addEventListener("load", toggleScrolled);

  /**
   * Mobile nav toggle
   */
  const mobileNavToggleBtn = document.querySelector(".mobile-nav-toggle");

  function mobileNavToogle() {
    document.querySelector("body").classList.toggle("mobile-nav-active");
    mobileNavToggleBtn.classList.toggle("bi-list");
    mobileNavToggleBtn.classList.toggle("bi-x");
  }
  if (mobileNavToggleBtn) {
    mobileNavToggleBtn.addEventListener("click", mobileNavToogle);
  }

  /**
   * Hide mobile nav on same-page/hash links
   */
  document.querySelectorAll("#navmenu a").forEach((navmenu) => {
    navmenu.addEventListener("click", () => {
      if (document.querySelector(".mobile-nav-active")) {
        mobileNavToogle();
      }
    });
  });

  /**
   * Toggle mobile nav dropdowns
   */
  document.querySelectorAll(".navmenu .toggle-dropdown").forEach((navmenu) => {
    navmenu.addEventListener("click", function (e) {
      e.preventDefault();
      this.parentNode.classList.toggle("active");
      this.parentNode.nextElementSibling.classList.toggle("dropdown-active");
      e.stopImmediatePropagation();
    });
  });

  /**
   * Preloader
   */
  const preloader = document.querySelector("#preloader");
  if (preloader) {
    window.addEventListener("load", () => {
      preloader.remove();
    });
  }

  /**
   * Scroll top button
   */
  let scrollTop = document.querySelector(".scroll-top");

  function toggleScrollTop() {
    if (scrollTop) {
      window.scrollY > 100
        ? scrollTop.classList.add("active")
        : scrollTop.classList.remove("active");
    }
  }
  scrollTop.addEventListener("click", (e) => {
    e.preventDefault();
    window.scrollTo({
      top: 0,
      behavior: "smooth",
    });
  });

  window.addEventListener("load", toggleScrollTop);
  document.addEventListener("scroll", toggleScrollTop);

  /**
   * Animation on scroll function and init
   */
  function aosInit() {
    AOS.init({
      duration: 600,
      easing: "ease-in-out",
      once: true,
      mirror: false,
    });
  }
  window.addEventListener("load", aosInit);

  /**
   * Init swiper sliders
   */
  function initSwiper() {
    document.querySelectorAll(".init-swiper").forEach(function (swiperElement) {
      let config = JSON.parse(
        swiperElement.querySelector(".swiper-config").innerHTML.trim()
      );

      if (swiperElement.classList.contains("swiper-tab")) {
        initSwiperWithCustomPagination(swiperElement, config);
      } else {
        new Swiper(swiperElement, config);
      }
    });
  }

  window.addEventListener("load", initSwiper);

  /**
   * Initiate Pure Counter
   */
  new PureCounter();

  /**
   * Init isotope layout and filters
   */
  document.querySelectorAll(".isotope-layout").forEach(function (isotopeItem) {
    let layout = isotopeItem.getAttribute("data-layout") ?? "masonry";
    let filter = isotopeItem.getAttribute("data-default-filter") ?? "*";
    let sort = isotopeItem.getAttribute("data-sort") ?? "original-order";

    let initIsotope;
    imagesLoaded(isotopeItem.querySelector(".isotope-container"), function () {
      initIsotope = new Isotope(
        isotopeItem.querySelector(".isotope-container"),
        {
          itemSelector: ".isotope-item",
          layoutMode: layout,
          filter: filter,
          sortBy: sort,
        }
      );
    });

    isotopeItem
      .querySelectorAll(".isotope-filters li")
      .forEach(function (filters) {
        filters.addEventListener(
          "click",
          function () {
            isotopeItem
              .querySelector(".isotope-filters .filter-active")
              .classList.remove("filter-active");
            this.classList.add("filter-active");
            initIsotope.arrange({
              filter: this.getAttribute("data-filter"),
            });
            if (typeof aosInit === "function") {
              aosInit();
            }
          },
          false
        );
      });
  });

  /**
   * Initiate glightbox
   */
  const glightbox = GLightbox({
    selector: ".glightbox",
  });

  /**
   * Set active state based on current page
   */
  function setActiveNavItem() {
    const currentPath = window.location.pathname;
    const currentPage = currentPath.split("/").pop() || "index.html";

    // Remover todas las clases active primero
    document.querySelectorAll("#navmenu a").forEach((link) => {
      link.classList.remove("active");
    });

    // Buscar el link que corresponde a la página actual
    document.querySelectorAll("#navmenu a").forEach((link) => {
      const linkPath = link.getAttribute("href");

      // Comparar la página actual con el href
      if (linkPath === currentPage || linkPath === `./${currentPage}`) {
        link.classList.add("active");
      }

      // Caso especial para index.html (también responde a Home)
      if (currentPage === "index.html" || currentPage === "") {
        if (
          linkPath === "index.html" ||
          linkPath === "./index.html" ||
          linkPath === "/"
        ) {
          link.classList.add("active");
        }
      }

      // Para páginas de estadía, bienestar y eventos, marcar las categorías padre
      if (
        currentPage === "habitaciones.html" ||
        currentPage === "domos.html" ||
        currentPage === "alojamiento.html"
      ) {
        if (linkPath === "estadia.html") {
          link.classList.add("active");
        }
      }

      if (
        currentPage === "spa.html" ||
        currentPage === "gimnasio.html" ||
        currentPage === "piscinas.html"
      ) {
        if (linkPath === "bienestar.html") {
          link.classList.add("active");
        }
      }
    });
  }

  /**
   * Navbar active state on scroll (solo para navegación con anclas en la misma página)
   */
  window.addEventListener("scroll", function () {
    // Solo ejecutar si estamos en una página con secciones ancla (como index.html)
    const hasSections =
      document.querySelector("#hero") || document.querySelector("[id]");
    if (!hasSections) return;

    let position = window.scrollY + 200;
    let activeFound = false;

    document.querySelectorAll("#navmenu a").forEach(function (navLink) {
      if (!navLink.hash) return;
      let section = document.querySelector(navLink.hash);
      if (!section) return;

      if (
        position >= section.offsetTop &&
        position <= section.offsetTop + section.offsetHeight
      ) {
        if (!activeFound) {
          document
            .querySelectorAll("#navmenu a")
            .forEach((el) => el.classList.remove("active"));
          navLink.classList.add("active");
          activeFound = true;
        }
      }
    });
  });

  // Ejecutar al cargar la página
  window.addEventListener("load", setActiveNavItem);
})();
